% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_measures.R
\name{cohens_kappa}
\alias{cohens_kappa}
\title{Calculate Cohen's Kappa}
\usage{
cohens_kappa(rater_one, rater_two)
}
\arguments{
\item{rater_one}{\code{factor} rating of the first coder.}

\item{rater_two}{\code{factor} ratings of the second coder.}
}
\value{
Returns a \code{list} containing the results for Cohen' Kappa if no weights
are applied (\code{kappa_unweighted}), if weights are applied and the weights increase
linear (\code{kappa_linear}), and if weights are applied and the weights increase quadratic
(\code{kappa_squared}).
}
\description{
This function calculates different version of Cohen's Kappa.
}
\references{
Cohen, J (1968). Weighted kappa: Nominal scale agreement
with provision for scaled disagreement or partial credit.
Psychological Bulletin, 70(4), 213–220. \url{doi:10.1037/h0026256}

Cohen, J (1960). A Coefficient of Agreement for Nominal Scales.
Educational and Psychological Measurement, 20(1), 37–46. \url{doi:10.1177/001316446002000104}
}
\seealso{
Other performance measures: 
\code{\link{calc_standard_classification_measures}()},
\code{\link{fleiss_kappa}()},
\code{\link{get_coder_metrics}()},
\code{\link{gwet_ac}()},
\code{\link{kendalls_w}()},
\code{\link{kripp_alpha}()}
}
\concept{performance measures}
