% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_alphabetr.R
\name{read_alphabetr}
\alias{read_alphabetr}
\title{Read in alphabetr sequencing data into the binary matrix form needed by bagpipe()}
\usage{
read_alphabetr(data = NULL, data_alpha = NULL, data_beta = NULL)
}
\arguments{
\item{data}{To read in a 3-column csv file containing both TCRA and TCRB
sequencing information}

\item{data_alpha}{To read in a 2-column csv file containing TCRA sequencing
information. Must be used in conjunction with the \code{data_beta}
argument and cannot be used with the \code{data} argument.}

\item{data_beta}{To read in a 2-column csv file containing TCRB sequencing
information. Must be used in conjunction with the \code{data_alpha}
argument and cannot eb used with the \code{data} argument.}
}
\value{
A list of two binary matrices that represent the sequencing data and
   two character vectors that give the CDR3 sequences associated with each
   chain index.
}
\description{
\code{read_alphabetr()} will read in two different forms of a csv file to
convert sequencing data using the alphabetr approach into the binary
matrices required by \code{\link{bagpipe}}. The csv file(s) can have one of
two forms. (1) A single csv file with three columns: column 1 containing
whether the sequence is "TCRA" or "TCRB"; column 2 containing the well
number; and column 3 containing the CDR3 sequence
(2) Two CSV files, one for TCRA and one for TCRB, with two columns: column
1 containing the well number and column 2 containing the CDR3 sequence
}
\examples{
\dontrun{
  dat <- read_alphabetr(data = "alphabetr_data.csv")

  # saving the alpha and beta binary matrices
  data_alpha <- dat$alpha
  data_beta  <- dat$beta

  # finding the cdr3 sequences of alpha_2 and beta_4 respectively
  cdr3_alpha2 <- dat$alpha_lib[2]
  cdr3_beta4  <- dat$beta_lib[4]
}
}

