% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amber.interviews.R
\name{amber.campaign}
\alias{amber.campaign}
\title{Get a campaign}
\usage{
amber.campaign(amber, id, study = NULL, interviewDesign = NULL, query = list())
}
\arguments{
\item{amber}{An Amber object}

\item{id}{Interview design's name or identifier}

\item{study}{Study identifier (name or id), optional.}

\item{interviewDesign}{Interview design identifier (name or id), optional.}

\item{query}{A search query}
}
\value{
A campaign object as a named list
}
\description{
Get an interview design campaign by its name or identifier.
}
\examples{
\dontrun{
a <- amber.login("https://amber-demo.obiba.org")
amber.campaign(a, id = "base", interviewDesign = "Adult trauma - baseline")
amber.logout(a)
}
}
\seealso{
Other studies functions: 
\code{\link{amber.campaigns}()},
\code{\link{amber.case_report_export}()},
\code{\link{amber.case_report_form}()},
\code{\link{amber.case_report_forms}()},
\code{\link{amber.case_reports}()},
\code{\link{amber.form}()},
\code{\link{amber.form_revision}()},
\code{\link{amber.form_revisions}()},
\code{\link{amber.forms}()},
\code{\link{amber.interview_design}()},
\code{\link{amber.interview_designs}()},
\code{\link{amber.interview_export}()},
\code{\link{amber.interviews}()},
\code{\link{amber.interviews_step_actions}()},
\code{\link{amber.interviews_step_data}()},
\code{\link{amber.interviews_steps}()},
\code{\link{amber.participant}()},
\code{\link{amber.participants}()},
\code{\link{amber.studies}()},
\code{\link{amber.study}()}
}
\concept{studies functions}
