% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonparTrawlEstimation.R
\name{asymptotic_variance}
\alias{asymptotic_variance}
\title{Computing the true asymptotic variance in the CLT of the
trawl estimation}
\usage{
asymptotic_variance(t, c4, varlevyseed = 1, trawlfct, trawlfct_par)
}
\arguments{
\item{t}{Time point at which the asymptotic variance is computed}

\item{c4}{The fourth cumulant of the Levy seed of the trawl process}

\item{varlevyseed}{The variance of the Levy seed of the trawl process,
the default is 1}

\item{trawlfct}{The trawl function for which the
asymptotic variance will be computed (Exp, supIG or LM)}

\item{trawlfct_par}{The parameter vector of the trawl function
(Exp: lambda, supIG: delta, gamma, LM: alpha, H)}
}
\value{
The function returns \eqn{\sigma_{a}^{2}(t)}.
}
\description{
This function computes the theoretical asymptotic variance
appearing in the CLT of the trawl process for a given trawl function and
fourth cumulant.
}
\details{
As derived in
Sauri and Veraart (2022), the asymptotic variance in the central limit
theorem for the trawl function estimation is given by
\deqn{\sigma_{a}^{2}(t)=c_{4}(L')a(t)+2\{ \int_{0}^{\infty}a(s)^{2}ds+
\int_{0}^{t}a(t-s)a(t+s)ds-\int_{t}^{\infty}a(s-t)a(t+s)ds\},}
for \eqn{t>0}.
The integrals in the above formula are approximated numerically.
}
\examples{
#Compute the asymptotic variance at time t for an exponential trawl with
#parameter 2; here we assume that the fourth cumulant equals 1.
av<-asymptotic_variance(t=1, c4=1, varlevyseed=1, trawlfct="Exp", trawlfct_par=2)
#Print the av
av$v
#Print the four components of the asymptotic variance separately
av$v1
av$v2
av$v3
av$v4

#Note that v=v1+v2+v3+v4
av$v
av$v1+av$v2+av$v3+av$v4
}
