% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_level_confidence_intervals.R
\name{node_level_CI}
\alias{node_level_CI}
\title{To obtain confidence intervals for node-level network metrics}
\usage{
node_level_CI(
  network,
  n_versions = 100,
  network_metrics_functions_list = c(degree = igraph::degree, strength =
    igraph::strength, betweenness = igraph::betweenness, clustering_coefficient =
    function(x) {
     trans <- igraph::transitivity(x, type = "local", vids =
    igraph::V(x), isolates = "zero")
     names(trans) <- igraph::V(x)$name
    
    return(trans)
 }, eigenvector_centrality = function(x)
    igraph::eigen_centrality(x)$vector),
  n_cores = 1,
  CI_size = 0.95
)
}
\arguments{
\item{network}{An igraph graph object consisting of observed network.}

\item{n_versions}{Number of bootstrapped versions to be used. (default = 100)}

\item{network_metrics_functions_list}{A list consisting of function definitions of the network metrics that the user wants to evaluate. Each element in the list should have an assigned name. Each function 
definition should include two parameters, one for the main network and another one for the subnetwork. See default example.
network_metrics_functions_list = c("degree" = igraph::degree, 
"strength" = igraph::strength , 
"betweenness" = igraph::betweenness, 
"clustering_coefficient" = function(x) \{
trans <- igraph::transitivity(x, type = "local", isolates = "zero")
names(trans) <- igraph::V(x)$name;return(trans)
\},
"eigenvector_centrality" = function(x) igraph::eigen_centrality(x)$vector
)}

\item{n_cores}{Number of cores for parallel processing with default 1.}

\item{CI_size}{Size of confidence interval. Default is 0.95 that generates a 95\% confidence interval.}
}
\value{
A list of dataframes of class list_node_level_CI. Each element of list is a dataframe having five columns and
        having number of rows equal to number of nodes in the network. The five columns correspond to node_number,
        node_name, metric_value, lower_CI, upper_CI.
        correspond to subsampling_proportion and rows correspond to n_simulations.
        The entries of the matrix provide value of correlation between the nodes in 
        full network and the sub-sampled network for the corresponding metric.
}
\description{
To obtain confidence intervals for node-level network metrics
}
\examples{
 \donttest{
data(elk_network_2010)
elk_node_level_CI <- node_level_CI(elk_network_2010)
plot(elk_node_level_CI)
}
}
