% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrapping.R
\name{obtain_bootstrapped_samples}
\alias{obtain_bootstrapped_samples}
\title{To obtain bootstrapped versions of a network's adjacency matrix}
\usage{
obtain_bootstrapped_samples(
  network,
  n_nodes = igraph::gorder(network),
  n_versions = 1000,
  seed = 12345
)
}
\arguments{
\item{network}{An igraph object}

\item{n_nodes}{Number of nodes to be selected in bootstrapped versions (default : All nodes)}

\item{n_versions}{Number of bootstrapped versions required}

\item{seed}{seed number}
}
\value{
A list of class bootstrapped_pvalue_matrix consisting of two elements. The first element contains the adjacency matrix of the original network 
        and the second element contains bootstrapped versions of the adjacency matrices.
}
\description{
To obtain bootstrapped versions of a network's adjacency matrix
}
\examples{
data(elk_network_2010)
obtain_bootstrapped_samples(elk_network_2010, n_versions = 100)
}
