% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getValues.R
\name{getValues}
\alias{getValues}
\title{Get values of a variable}
\usage{
getValues(data = NULL, variable = NULL, mcyear = "all")
}
\arguments{
\item{data}{an object of class "antaresData" created with the function
\code{readAntares}.}

\item{variable}{a variable of data}

\item{mcyear}{set of mcYear}
}
\value{
A data.table, data.frame class object containing the study's output data
}
\description{
Get all the values of a variable for some years Monte Carlo
}
\examples{
\donttest{
library(antaresRead)
# with study test for example (study is in package antaresRead)
sourcedir <- system.file("testdata", package = "antaresRead")

# untar study in temp dir
path_latest <- file.path(tempdir(), "latest")
untar(file.path(sourcedir, "antares-test-study.tar.gz"), exdir = path_latest)

study_path <- file.path(path_latest, "test_case")

# set path to your Antares simulation
opts <- setSimulationPath(study_path)

# read output simulation
mydata <- readAntares(areas = "all",
                      links = "all",
                      clusters = "all",
                      timeStep = "annual",
                      mcYears = "all")

# get values of a variable
getValues(mydata$areas, variable="LIGNITE")
getValues(mydata$clusters, variable = "NODU")

}
}
