% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractDataList.R
\name{extractDataList}
\alias{extractDataList}
\title{Format data PPSE-style}
\usage{
extractDataList(x, areas = NULL)
}
\arguments{
\item{x}{object of class "antaresData" or "antaresTable" created by the function
\code{\link{readAntares}}}

\item{areas}{character vector containing the name of areas to keep in the
final object. If \code{NULL}, all areas are kept in the final object.}
}
\value{
a list of data.tables with one element per area. The list also
contains an element named "areaList" containing the name of areas in the
object and a table called "infos" that contains for each area the number
of variables of different type (values, details, link).
}
\description{
This function converts an "readAntares" object in the data structure used
by PPSE : instead of having one table for areas, one for links and one for
clusters, the function creates a list with one element per area. Each element
is a data.table containing the data about the area and one column per cluster
of the area containing the production of this cluster.
}
