% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiphyDat.class.R
\docType{class}
\name{multiphyDat-class}
\alias{multiphyDat-class}
\alias{multiphyDat}
\title{multiphyDat: class for multiple gene data}
\description{
This formal (S4) class is identical to \linkS4class{multidna}, except that DNA sequences are stored using \code{phyDat} objects from the \code{phangorn} package.
Sequences are stored as a (possibly named) list, with each element of the list being a separate DNA alignment stored as a \code{phyDat} object.
The rows of the separate matrices all correspond to the same individuals, ordered identically.
}
\section{Slots}{

\describe{
\item{\code{seq}}{a list of phyDat objects; empty slot should be NULL}

\item{\code{type}}{a character string indicating the type of the sequences stored: "DNA" for DNA sequences, "AA" for amino-acids.}

\item{\code{labels}}{a vector of labels of individuals}

\item{\code{n.ind}}{the number of individuals}

\item{\code{n.seq}}{the total number of sequences (pooling all genes), including gap sequences}

\item{\code{n.seq.miss}}{the total number of gap-only sequences}

\item{\code{ind.info}}{a data.frame containing information on the individuals, where individuals are in rows; empty slot should be NULL}

\item{\code{gene.info}}{a data.frame containing information on the genes, where genes are in rows; empty slot should be NULL}
}}

\examples{
data(Laurasiatherian)

## empty object
new("multiphyDat")

## simple conversion with nicely ordered output
data(Laurasiatherian)
genes <- list(gene1=Laurasiatherian[, 1:1600],
              gene2=Laurasiatherian[, 1601:3179])
x <- new("multiphyDat", genes)
x

## trickier conversion with missing sequences / wrong order
genes <- list(gene1=Laurasiatherian[1:40,],
    gene2=Laurasiatherian[8:47,])
x <- new("multiphyDat", genes)
x

}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}

Thibaut Jombart \email{t.jombart@imperial.ac.uk}
}
