% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_raster.R
\name{raster_colors}
\alias{raster_colors}
\title{Convert RasterLayer into data.frame of colors for each pixel that can be
used for plotting}
\usage{
raster_colors(x)
}
\arguments{
\item{x}{A Raster* object}
}
\value{
A data.frame with 3 columns and \code{length(raster_object)} rows.
Two of these columns are the x-y coordinates of each pixel, and one is a
value for color that can be used for plotting
}
\description{
This function is used internally by \code{\link{plot_layer}} to convert a
Raster* object to a data.frame of colors for each pixel that can be used for
plotting with ggplot2
}
\examples{
\dontrun{
wi_landcover <- get_map_layer(wi_landcover_url, wis_poly)
wi_landcover_data <- raster_colors(wi_landcover)
head(wi_landcover_data)
}
}
