% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsets_performance.R
\name{calculate_subsets_performance}
\alias{calculate_subsets_performance}
\title{Internal function for calculating data for funnel plot}
\usage{
calculate_subsets_performance(
  explainer,
  score_functions = list(),
  nbins = 5,
  cutoff = 0.01,
  cutoff_name = "Other",
  factor_conversion_threshold = 7
)
}
\arguments{
\item{explainer}{Explainer created using \code{DALEX::explain}}

\item{score_functions}{Named list of functions named \code{score_*} from \code{auditor} package}

\item{nbins}{Number of qunatiles (partition points) for numeric columns. In case when more than one qunatile have the same value, there will be less partition points.}

\item{cutoff}{Threshold for categorical data. Entries less frequent than specified value will be merged into one category.}

\item{cutoff_name}{Name for new category that arised after merging entries less frequent than \code{cutoff}}

\item{factor_conversion_threshold}{Numeric columns with lower number of unique values than value of this parameter will be treated as factors}
}
\value{
Data frame with columns
\itemize{
  \item{Variable}{ Name of splited variable}
  \item{Label}{ Label for variable's values subset}
}
and one column for each score function with returned score
}
\description{
This is modified version of \code{DALEXtra::funnel_measure}
}
