% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aricode.R
\name{NMI}
\alias{NMI}
\title{Normalized mutual information (NMI)}
\usage{
NMI(c1, c2, variant = c("max", "min", "sqrt", "sum", "joint"))
}
\arguments{
\item{c1}{a vector containing the labels of the first classification. Must be a vector of characters, integers, numerics, or a factor, but not a list.}

\item{c2}{a vector containing the labels of the second classification.}

\item{variant}{a string in ("max", "min", "sqrt", "sum", "joint"): different variants of NMI. Default use "max".}
}
\value{
a scalar with the normalized mutual information .
}
\description{
A function to compute the NMI between two classifications
}
\examples{
data(iris)
cl <- cutree(hclust(dist(iris[,-5])), 4)
NMI(cl,iris$Species)
}
\seealso{
\code{\link{RI}}, \code{\link{NID}}, \code{\link{NVI}}, \code{\link{ARI}}, \code{\link{clustComp}}
}
