% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter.R
\docType{class}
\name{ASparameter-classes}
\alias{ASparameter-classes}
\alias{parameter}
\alias{initialize,ASparameter-method}
\alias{show,ASparameter-method}
\alias{ASparameter-class}
\alias{ASparameter}
\alias{APparameter-class}
\alias{APparameter}
\alias{initialize,APparameter-method}
\alias{ECparameter-class}
\alias{ECparameter}
\alias{initialize,ECparameter-method}
\alias{coercion}
\alias{coerce,NULL,APparameter-method}
\alias{coerce,list,APparameter-method}
\alias{coerce,NULL,ECparameter-method}
\alias{coerce,list,ECparameter-method}
\title{Classes ASparameter, APparameter, ECparameter ---
Specifying the parameter Argument of APRIORI and ECLAT}
\description{
The \code{ASparameter} class holds the mining parameters (e.g., minimum
support) for the used mining algorithms.  \code{APparameter} and
\code{ECparameter} directly extend \code{ASparameter} with additional slots
for parameters only suitable for \code{\link[=apriori]{apriori()}} (\code{APparameter}) or \code{\link[=eclat]{eclat()}}
(\code{ECparameter}).
}
\section{Slots}{

\describe{
\item{\code{support}}{a numeric value for the
minimal support of an item set (default: \eqn{0.1})}

\item{\code{minlen}}{an integer value for the
minimal number of items per item set (default: 1 item)}

\item{\code{maxlen}}{an integer value for the
maximal number of items per item set (default: 10 items)}

\item{\code{target}}{a character string indicating the type of association mined.
Partial names are matched. Available targets are:
\itemize{
\item \code{"frequent itemsets"}
\item \code{"maximally frequent itemsets"}
\item \code{"generator frequent itemsets"}
\item \code{"closed frequent itemsets"}
\item \code{"rules"} only available for \link{apriori};
use \link{ruleInduction} for \link{eclat}.
\item \code{"hyperedgesets"} only available for \link{apriori};
see references for the definition of association hyperedgesets.
}}

\item{\code{ext}}{a logical indicating whether to report coverage (i.e., LHS-support)
as an extended quality measure (default: \code{TRUE})}

\item{\code{confidence}}{a numeric value for the
minimal confidence of rules/association hyperedges (default:
\eqn{0.8}). For frequent itemsets it is set to \code{NA}.}

\item{\code{smax}}{a numeric value for the
maximal support of itemsets/rules/hyperedgesets (default: 1)}

\item{\code{arem}}{a character string indicating the used additional rule
evaluation measure (default: \code{"none"}) given by one of
\itemize{
\item \code{"none"}: no additional evaluation measure
\item \code{"diff"}: absolute confidence difference
\item \code{"quot"}: difference of confidence quotient to 1
\item \code{"aimp"}: absolute difference of improvement to 1
\item \code{"info"}: information difference to prior
\item \code{"chi2"}: normalized \eqn{\chi^2} measure
}

\strong{Note:} The measure is only reported if \code{aval} is set to \code{TRUE}.
Use \code{minval} to set minimum thresholds on the measures.}

\item{\code{aval}}{a logical indicating whether to
return the additional rule evaluation measure selected with \code{arem}.}

\item{\code{minval}}{a numeric value for the minimal value of additional
evaluation measure selected with \code{arem} (default: \eqn{0.1})}

\item{\code{originalSupport}}{a logical indicating whether to
use the original definition of minimum support
(support of the LHS and RHS of the rule). If set to \code{FALSE}
then the support of the LHS (also called coverage of the rule) is returned as support.
The minimum support threshold is applied to this support. (default: \code{TRUE})}

\item{\code{maxtime}}{Time limit in seconds for checking subsets.
\code{maxtime = 0} disables the time limit. (default: 5 seconds)}

\item{\code{tidLists}}{a logical indicating whether \code{\link[=eclat]{eclat()}} should
return also a list of supporting transactions IDs.
(default: \code{FALSE})}
}}

\section{Available Slots by Subclass}{

\itemize{
\item \code{APparameter}:
\code{confidence}, \code{minval}, \code{smax}, \code{arem}, \code{aval}, \code{originalSupport}, \code{maxtime}, \code{support}, \code{minlen}, \code{maxlen}, \code{target}, \code{ext}
\item \code{ECparameter}:
\code{tidLists}, \code{support}, \code{minlen}, \code{maxlen}, \code{target}, \code{ext}
}
}

\section{Objects from the Class}{

A suitable default parameter object will be
automatically created by \code{\link[=apriori]{apriori()}} or
\code{\link[=eclat]{eclat()}}.  By specifying a named list (names equal to
slots) as \code{parameter} argument for \code{\link[=apriori]{apriori()}} or
\code{\link[=eclat]{eclat()}}, the default values can be replaced with the values
in the list.

Objects can also be created via coercion.
}

\section{Coercions}{

\itemize{
\item \code{as("NULL", "APparameter")}
\item \code{as("list", "APparameter")}
\item \code{as("NULL", "ECparameter")}
\item \code{as("list", "ECparameter")}
}
}

\references{
Christian Borgelt (2004) \emph{Apriori --- Finding Association
Rules/Hyperedges with the Apriori Algorithm}.
\url{https://borgelt.net/apriori.html}
}
\seealso{
Other mining algorithms: 
\code{\link{APappearance-class}},
\code{\link{AScontrol-classes}},
\code{\link{apriori}()},
\code{\link{eclat}()},
\code{\link{fim4r}()},
\code{\link{ruleInduction}()},
\code{\link{weclat}()}
}
\author{
Michael Hahsler and Bettina Gruen
}
\concept{mining algorithms}
\keyword{classes}
