% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DATAFRAME.R
\name{DATAFRAME}
\alias{DATAFRAME}
\alias{DATAFRAME,rules-method}
\alias{DATAFRAME,itemsets-method}
\alias{DATAFRAME,itemMatrix-method}
\title{Data.frame Representation for arules Objects}
\usage{
DATAFRAME(from, ...)

\S4method{DATAFRAME}{rules}(from, separate = TRUE, ...)

\S4method{DATAFRAME}{itemsets}(from, ...)

\S4method{DATAFRAME}{itemMatrix}(from, ...)
}
\arguments{
\item{from}{the object to be converted into a data.frame.}

\item{...}{further arguments are passed on to the \code{labels()} method defined for the object in \code{from}.}

\item{separate}{logical; separate LHS and RHS in separate columns? (only for rules)}
}
\value{
a data.frame.
}
\description{
Provides the generic function \code{DATAFRAME()} and the methods to create
a data.frame representation from some arules objects.
These methods are used for the coercion to a
data.frame, but offer more control over the coercion process (item
separators, etc.).
}
\details{
Using \code{DATAFRAME()} is equivalent to the standard coercion
\code{as(x, "data.frame")}.  However, for rules, the argument \code{separate = TRUE}
will produce separate columns for the LHS and the RHS of the rule.

Furthermore, the arguments \code{itemSep}, \code{setStart}, \code{setEnd}
(and \code{ruleSep} for \code{separate = FALSE}) will be passed on to the
\code{labels()} method for the object specified in \code{from}.
}
\examples{
data(Adult)

DATAFRAME(head(Adult))
DATAFRAME(head(Adult), setStart = "", itemSep = " + ", setEnd = "")

rules <- apriori(Adult,
  parameter = list(supp = 0.5, conf = 0.9, target = "rules")
)
rules <- head(rules, by = "conf")


### default coercions (same as as(rules, "data.frame"))
DATAFRAME(rules)

DATAFRAME(rules, separate = TRUE)
DATAFRAME(rules, separate = TRUE, setStart = "", itemSep = " + ", setEnd = "")
}
\seealso{
Other import/export: 
\code{\link{LIST}()},
\code{\link{pmml}},
\code{\link{read}},
\code{\link{write}()}
}
\author{
Michael Hahsler
}
\concept{import/export}
\keyword{manip}
