% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subset}
\alias{subset}
\alias{subset,itemMatrix-method}
\alias{subset,itemsets-method}
\alias{subset,rules-method}
\title{Subsetting Itemsets, Rules and Transactions}
\usage{
subset(x, ...)

\S4method{subset}{itemMatrix}(x, subset, ...)

\S4method{subset}{itemsets}(x, subset, ...)

\S4method{subset}{rules}(x, subset, ...)
}
\arguments{
\item{x}{object to be subsetted.}

\item{...}{further arguments to be passed to or from other methods.}

\item{subset}{logical expression indicating elements to keep.}
}
\value{
An object of the same class as \code{x} containing only the elements
which satisfy the conditions.
}
\description{
Provides the generic function \code{subset()} and methods to subset
\link{associations} or \link{transactions} (\link{itemMatrix}) which meet certain conditions
(e.g., contains certain items or satisfies a minimum lift).
}
\details{
\code{subset()} finds the rows/itemsets/rules of \code{x} that match the expression
given in \code{subset}. Parts of \code{x} like items, lhs, rhs and the columns in the quality data.frame (e.g., support and lift) can be directly referred to by their names
in \code{subset}.

Important operators to select itemsets containing items specified by their
labels are
\itemize{
\item \link{\%in\%}: select itemsets matching \emph{any} given item
\item \link{\%ain\%}: select only itemsets matching \emph{all} given item
\item \link{\%oin\%}: select only itemsets matching \emph{only} the given item
\item \link{\%pin\%}: \code{\%in\%} with \emph{partial matching}
}
}
\examples{
data("Adult")
rules <- apriori(Adult)

## select all rules with item "marital-status=Never-married" in
## the right-hand-side and lift > 2
rules.sub <- subset(rules, subset = rhs \%in\% "marital-status=Never-married" &
  lift > 2)

## use partial matching for all items corresponding to the variable
## "marital-status"
rules.sub <- subset(rules, subset = rhs \%pin\% "marital-status=")

## select only rules with items "age=Young" and "workclass=Private" in
## the left-hand-side
rules.sub <- subset(rules, subset = lhs \%ain\%
  c("age=Young", "workclass=Private"))
}
\author{
Michael Hahsler
}
\keyword{manip}
