% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_plot_distrib_2D.R
\name{f_plot_distrib_2D}
\alias{f_plot_distrib_2D}
\title{Plot of historical distributions in 2D}
\usage{
f_plot_distrib_2D(
  m_param_histo,
  type_function,
  v_date = NULL,
  v_var_dep,
  x_lab,
  y_lab,
  x_min = NULL,
  x_max = NULL,
  color_theme = c("#bd8e42", "gray30", "#876b3a", "khaki1")
)
}
\arguments{
\item{m_param_histo}{Numeric matrix containing the parameters of the f_param_histo function}

\item{type_function}{String argument specifying the distribution type (gaussian, skew-gaussian or skew-t)}

\item{v_date}{Vector optional of dates containing the full sample's dates (default value : daily dates starting from "1970-01-01")}

\item{v_var_dep}{Numeric vector containing the realization of the dependent variable}

\item{x_lab}{String optional argument for the x axis title (default value = x)}

\item{y_lab}{String optionalargument for the y axis title (default value = y)}

\item{x_min}{Numeric optional argument (default value = VaR 97.5)}

\item{x_max}{Numeric optional argument (default value = VaR 2.5)}

\item{color_theme}{A character vector specifying the color theme to use (default value c("#bd8e42","gray30","#876b3a","khaki1"))}
}
\value{
A plot of historical distributions with the median, four quantiles (5th, 25th, 75th, 95th) and the realized dependent variable.
}
\description{
This function allows to create a plot in 2D of historical distributions.
}
\examples{
# Import data
data(data_US)
data(data_param_histo_US)

results_plot_2D <- f_plot_distrib_2D(m_param_histo=data_param_histo_US,
type_function="skew-t",
v_date=data_US[,1],
v_var_dep=data_US[,2],
x_lab="US GDP variation",
y_lab="Year")
}
