% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acs.R
\name{get_candidate_covariates}
\alias{get_candidate_covariates}
\title{Generate candidate empirical baseline covariates based on prevalence in the baseline period}
\usage{
get_candidate_covariates(
  df,
  domainVarname,
  eventCodeVarname,
  patientIdVarname,
  patientIdVector,
  n = 200,
  min_num_patients = 100
)
}
\arguments{
\item{df}{The input \code{data.frame}. This should contain at least 3 fields containing information on patient identifier,
covariate codes and domain names of covariate codes in a long format. Any other fields containing values such as dates,
treatment group are optional and will be ignored for this analysis}

\item{domainVarname}{The variable(field) name which contains the domain of the covariate in the \code{df}.
The domains are usually diagnosis, procedures and medications.}

\item{eventCodeVarname}{The variable name which contains the covariate codes (eg:- CCS, ICD9) in the \code{df}}

\item{patientIdVarname}{The variable name which contains the patient identifier in the \code{df}}

\item{patientIdVector}{The 1-D vector with all the patient identifiers. The length of this vector should be equal to
the number of distinct patients in the \code{df}. This vector is not really used in the function analysis per se. This is
used only to return the same back as function output because the filtered \code{df} based on \code{covars} will likely not
contain all patients in the input \code{df} because there could be patients for whom no records were found for any of the
identified \code{covars} and they will thus be not present in the filtered \code{df} which is also an output of this function.
The \code{patientIds} vector output will contain all original patients and by returning this vector, it can later be  used in the
next steps of automated covariate selection because each step is dependent on previous steps and information on patients who did not
have any identified \code{covars} is also important for the next steps. This is why this vector is an input as well as an output, without
affecting the analysis of this function.}

\item{n}{The maximum number of empirical candidate baseline covariates that should be returned within each domain.
By default, n is 200}

\item{min_num_patients}{Minimum number of patients that should be present for each covariate to be selected for selection.
To be considered for selection, a covariate should have occurred for a minimum \code{min_num_patients} in the baseline period}
}
\value{
A named list containing three R objects
\itemize{
\item \code{covars}   A 1-D vector containing the names of selected baseline covariate names from each domain.
For each domain in the \code{df}, the number of \code{covars} would be equal to or less than \code{n}
\item \code{covars_data}   {The \code{data.frame} that is filtered out of \code{df} with only the selected \code{covars}}. The values of the
\code{eventCodeVarname} field is prefixed with the corresponding \code{domain} name. For example, if the event code is 19900 and the domain
is 'dx', then the the covariate name will be 'dx_19900'.
\item \code{patientIds}   {The list of patient ids present in the original input \code{df}. This is exactly the same as the input \code{patientIdVector}}
}
}
\description{
\code{get_candidate_covariates} function generates the list of candidate empirical covariates based on their prevalence
within each domains (dimensions). This is the first step in the automated covariate selection process. See 'Automated Covariate Selection'
section below for more details regarding the overall process.
}
\details{
The theoretical details of the high-dimensional propensity score (HDPS) algorithm is detailed in the publication listed below in the \code{References} section.
\code{get_candidate_covariates} is the function implementing what is described in the 'Identify candidate empirical covariates' section
of the article.
}
\section{Automated Covariate Selection}{

\strong{The three steps in automated covariate selection are listed below with the functions implementing the methodology}
\enumerate{
\item Identify candidate empirical covariates: \code{\link[autoCovariateSelection]{get_candidate_covariates}}
\item Assess recurrence: \code{\link[autoCovariateSelection]{get_recurrence_covariates}}
\item Prioritize covariates: \code{\link[autoCovariateSelection]{get_prioritised_covariates}}
}
}

\examples{
library("autoCovariateSelection")
data(rwd)
head(rwd, 3)
#select distinct elements that are unique for each patient - treatment and outcome
basetable <- rwd \%>\% select(person_id, treatment, outcome_date) \%>\% distinct()
head(basetable, 3)
patientIds <- basetable$person_id
step1 <- get_candidate_covariates(df = rwd,  domainVarname = "domain",
eventCodeVarname = "event_code", patientIdVarname = "person_id",
patientIdVector = patientIds,n = 100, min_num_patients = 10)
out1 <- step1$covars_data #this will be input to get_recurrence_covariates() function
}
\references{
Schneeweiss S, Rassen JA, Glynn RJ, Avorn J, Mogun H, Brookhart MA. High-dimensional propensity score adjustment in studies of treatment effects using health care claims data Epidemiology. 2009;20(4):512-522. doi:10.1097/EDE.0b013e3181a663cc
}
\author{
Dennis Robert \email{dennis.robert.nm@gmail.com}
}
