% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_gb.R
\name{run_gb}
\alias{run_gb}
\title{Apply gradient boosting classifier to MrP.}
\usage{
run_gb(
  y,
  L1.x,
  L2.x,
  L2.eval.unit,
  L2.unit,
  L2.reg,
  loss.unit,
  loss.fun,
  interaction.depth,
  shrinkage,
  n.trees.init,
  n.trees.increase,
  n.trees.max,
  cores = cores,
  n.minobsinnode,
  data,
  verbose
)
}
\arguments{
\item{y}{Outcome variable. A character vector containing the column names of
the outcome variable. A character scalar containing the column name of
the outcome variable in \code{survey}.}

\item{L1.x}{Individual-level covariates. A character vector containing the
column names of the individual-level variables in \code{survey} and
\code{census} used to predict outcome \code{y}. Note that geographic unit
is specified in argument \code{L2.unit}.}

\item{L2.x}{Context-level covariates. A character vector containing the
column names of the context-level variables in \code{survey} and
\code{census} used to predict outcome \code{y}. To exclude context-level
variables, set \code{L2.x = NULL}.}

\item{L2.eval.unit}{Geographic unit for the loss function. A character scalar
containing the column name of the geographic unit in \code{survey} and
\code{census}.}

\item{L2.unit}{Geographic unit. A character scalar containing the column
name of the geographic unit in \code{survey} and \code{census} at which
outcomes should be aggregated.}

\item{L2.reg}{Geographic region. A character scalar containing the column
name of the geographic region in \code{survey} and \code{census} by which
geographic units are grouped (\code{L2.unit} must be nested within
\code{L2.reg}). Default is \code{NULL}.}

\item{loss.unit}{Loss function unit. A character-valued scalar indicating
whether performance loss should be evaluated at the level of individual
respondents (\code{individuals}) or geographic units (\code{L2 units}).
Default is \code{individuals}.}

\item{loss.fun}{Loss function. A character-valued scalar indicating whether
prediction loss should be measured by the mean squared error (\code{MSE})
or the mean absolute error (\code{MAE}). Default is \code{MSE}.}

\item{interaction.depth}{GB interaction depth. An integer-valued vector
whose values specify the interaction depth of GB. The interaction depth
defines the maximum depth of each tree grown (i.e., the maximum level of
variable interactions). Default is \code{c(1, 2, 3)}.}

\item{shrinkage}{GB learning rate. A numeric vector whose values specify the
learning rate or step-size reduction of GB. Values between \eqn{0.001}
and \eqn{0.1} usually work, but a smaller learning rate typically requires
more trees. Default is \code{c(0.04, 0.01, 0.008, 0.005, 0.001)}.}

\item{n.trees.init}{GB initial total number of trees. An integer-valued
scalar specifying the initial number of total trees to fit by GB. Default
is \eqn{50}.}

\item{n.trees.increase}{GB increase in total number of trees. An
integer-valued scalar specifying by how many trees the total number of
trees to fit should be increased (until \code{n.trees.max} is reached)
or an integer-valued vector of length \code{length(shrinkage)} with each
of its values being associated with a learning rate in \code{shrinkage}.
Default is \eqn{50}.}

\item{n.trees.max}{GB maximum number of trees. An integer-valued scalar
specifying the maximum number of trees to fit by GB or an integer-valued
vector of length \code{length(shrinkage)} with each of its values being
associated with a learning rate and an increase in the total number of
trees. Default is \eqn{1000}.}

\item{cores}{The number of cores to be used. An integer indicating the number
of processor cores used for parallel computing. Default is 1.}

\item{n.minobsinnode}{GB minimum number of observations in the terminal
nodes. An integer-valued scalar specifying the minimum number of
observations that each terminal node of the trees must contain. Default is
\eqn{5}.}

\item{data}{Data for cross-validation. A \code{list} of \eqn{k}
\code{data.frames}, one for each fold to be used in \eqn{k}-fold
cross-validation.}

\item{verbose}{Verbose output. A logical argument indicating whether or not
verbose output should be printed. Default is \code{TRUE}.}
}
\value{
The tuned gradient boosting parameters. A list with three elements:
  \code{interaction_depth} contains the interaction depth parameter,
  \code{shrinkage} contains the learning rate, \code{n_trees} the number of
  trees to be grown.
}
\description{
\code{run_gb} is a wrapper function that applies the gradient boosting
classifier to data provided by the user, evaluates prediction performance,
and chooses the best-performing model.
}
