% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{fit_to_constraints}
\alias{fit_to_constraints}
\title{fit_to_constraints}
\usage{
fit_to_constraints(
  model_id,
  d,
  model_constraints,
  tr,
  roi_weights,
  allow_overlap,
  population,
  iter,
  mutation_rate,
  mutation_factor,
  elitism,
  hrf,
  t,
  p_boynton,
  p_spm,
  f,
  autohrf = NULL,
  verbose = TRUE
)
}
\arguments{
\item{model_id}{ID of the model.}

\item{d}{A dataframe with the signal data: roi, t and y. ROI is the name of
the region, t is the timestamp and y the value of the signal.}

\item{model_constraints}{A list of model specifications to use for fitting.
Each specification is represented as a data frame containing information
about it (event, start_time, end_time, min_duration and max_duration).}

\item{tr}{MRI's repetition time.}

\item{roi_weights}{A data frame with ROI weights: roi, weight. ROI is the
name of the region, weight a number that defines the importance of that roi,
the default weight for a ROI is 1. If set to 2 for a particular ROI that ROI
will be twice as important.}

\item{allow_overlap}{Whether to allow overlap between events.}

\item{population}{The size of the population in the genetic algorithm.}

\item{iter}{Number of iterations in the genetic algorithm.}

\item{mutation_rate}{The mutation rate in the genetic algorithm.}

\item{mutation_factor}{The mutation factor in the genetic algorithm.}

\item{elitism}{The degree of elitism (promote a percentage of the best
solutions) in the genetic algorithm.}

\item{hrf}{Method to use for HRF generation.}

\item{t}{The t parameter for Boynton or SPM HRF generation.}

\item{p_boynton}{Parameters for the Boynton's HRF.}

\item{p_spm}{Parameters for the SPM HRF.}

\item{f}{Upsampling factor.}

\item{autohrf}{Results of a previous autohrf run to continue.}

\item{verbose}{Whether to print progress of the fitting process.}
}
\value{
Returns the best model given provided constraints.
}
\description{
A helper function for fitting a model to constraints.
}
