% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theo_MOAV_NOAV.R
\name{NOAV}
\alias{NOAV}
\title{Non-stationary Non-overlapping Allan Variance}
\usage{
NOAV(n, covmat)
}
\arguments{
\item{n}{An \code{integer} indicating the length of each vector of consecutive observations considered for the average.}

\item{covmat}{A \code{matrix} indicating the T-by-T covariance matrix of the time series with length T.}
}
\value{
A \code{field <numeric>} that is the theoretical Non-overlapping Allan variance for constant-mean non-stationary time series data.
}
\description{
Calculation of the theoretical Non-overlapping Allan variance for constant-mean non-stationary time series data.
}
\details{
This calculation of Non-overlapping Allan variance is based on the definition on "A Study of the Allan Variance for Constant-Mean Non-Stationary Processes" by Xu et al., 2017, IEEE Signal Processing Letters, 24(8): 1257–1260.
Here n is an integer larger than 1 and smaller than \eqn{floor\left(log_2 \left(dim\left(covmat\right)[1]\right)\right)-1}{floor(log2(dim(T)[1]))-1}.
}
\examples{
\donttest{
set.seed(999)
Xt = arima.sim(n = 100, list(ar = 0.3))
avar(Xt, type = "to")

a = matrix(rep(0, 1000^2), nrow = 1000)
for (i in 1:1000){
  a[,i] = seq(from = 1 - i, length.out = 1000)
}
a.diag = diag(a)
a[upper.tri(a,diag=TRUE)] = 0
a = a + t(a) + diag(a.diag)
covmat = 0.3^a
sapply(1:8, function(y){NOAV(2^y, covmat)})
}

}
\author{
Haotian Xu
}
