% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traffic_history.R
\name{traffic_history}
\alias{traffic_history}
\title{Get Traffic History of a URL}
\usage{
traffic_history(url = NULL, range = 31, start = NULL, ...)
}
\arguments{
\item{url}{String; Required; valid url}

\item{range}{Integer; Required; Default is 31, Maximum is 31. Pick an integer between 1 and 31.}

\item{start}{String; Optional; A date within the last 4 years in format YYYYMMDD.}

\item{\dots}{Additional arguments passed to \code{\link{alexa_GET}}.}
}
\value{
data.frame with the following columns: \code{site, start, range,
date, page_views_per_million, page_views_per_user, rank, reach_per_million}
}
\description{
Get Traffic History of a URL
}
\examples{
\dontrun{
traffic_history(url = "http://www.google.com", start = "20160505")
}
}
\references{
\url{https://docs.aws.amazon.com/AlexaWebInfoService/latest/ApiReference_TrafficHistoryAction.html}
}
