% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute_pam.R
\name{permute_pam}
\alias{permute_pam}
\title{permute_pam: Function to permute a Presence-Absence-Matrix.}
\usage{
permute_pam(m, niter = NULL, as_sparse = FALSE, randal = "indep_swap")
}
\arguments{
\item{m}{Presence-Absence-Matrix (PAM) or a binary matrix with columns
representing species and rows sites.}

\item{niter}{Number of iterations to permute the PAM.}

\item{as_sparse}{If TRUE the PAM will be returned as a sparse matrix}

\item{randal}{Randomization algorithm applied to the PAM.
Possible choices "curveball", "fastball", and "indep_swap".}
}
\value{
Returns a permuted matrix of the same dimensions of m
(same number of rows and columns). Note that the sum of each row and column
of this permuted matrix is equal to that of m.
species.
}
\description{
permute_pam: Function to permute a Presence-Absence-Matrix.
}
\details{
This function can use the "curveball" (Strona et al., 2014), the
         fastball (Godard and Neal, 2022), and the independent swap
         algorithms. The implementation of the "fastball" in C++ is provided
         in \url{https://github.com/zpneal/fastball/blob/main/fastball.cpp}.
         Please when using the "fastball" algorithm for publications cite
         Godard and Neal (2022). When using the "curveball" cite
         Strona et al. (2014). When using independent swap ("indep_swap")
         cite Kembel et al. (2010)
}
\examples{
set.seed(111)
pam <- matrix(rbinom(100,1,0.3),nrow = 10,ncol = 10)
ppam <- bamm::permute_pam(m = pam,niter = NULL,as_sparse = FALSE)
# Check if matrices are different
all(pam == ppam)
# Check if row totals are the same
all(Matrix::rowSums(pam) == Matrix::rowSums(ppam))
# Check if column total are the same
all(Matrix::colSums(pam) == Matrix::colSums(ppam))
}
\references{
\insertRef{Strona2014}{bamm}

\insertRef{Gordard2022}{bamm}

\insertRef{Kembel2010}{bamm}
}
\author{
Luis Osorio-Olvera & Jorge Soberón
}
