% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_lambda.R
\name{adjust_lambda.default}
\alias{adjust_lambda.default}
\title{Adjust Lambda}
\usage{
\method{adjust_lambda}{default}(
  design,
  n,
  p1 = NULL,
  alpha = 0.05,
  design_params = list(),
  iter = 1000,
  prec_digits = 3,
  data = NULL,
  ...
)
}
\arguments{
\item{design}{An object created with one of the \code{setup} functions.}

\item{n}{The sample size per basket.}

\item{p1}{Probabilities under the alternative hypothesis. If \code{NULL}
then the type 1 error rate under the global null hypothesis is
calculated.}

\item{alpha}{The one-sided significance level.}

\item{design_params}{A list of params that is specific to the class of
\code{design}.}

\item{iter}{The number of iterations in the simulation. Is ignored if
\code{data} is specified.}

\item{prec_digits}{Number of decimal places that are considered when
adjusting lambda.}

\item{data}{A data matrix with k column with the number of responses for each
basket. Has to be generated with \code{get_data}. If \code{data} is used,
then \code{iter} is ignored.}

\item{...}{Further arguments.}
}
\value{
A list containing the greatest estimated value for \code{lambda} with
\code{prec_digits} decimal places which controls the family wise error rate
at level \code{alpha} (one-sided) and the estimated family wise error rate
for the estimated \code{lambda}.
}
\description{
Adjust Lambda
}
\details{
It is recommended to use \code{data} and then use the same simulated
data set for all further calculations. If \code{data = NULL} then
new data is generated in each step of the algorithm, so \code{lambda} doesn't
necessarily protect the family wise error rate for different simulated data
due to Monte Carlo simulation error.
}
\examples{
# Example for a basket trial with Fujikawa's Design
design <- setup_fujikawa(k = 3, p0 = 0.2)
adjust_lambda(design = design, n = 20, alpha = 0.05,
  design_params = list(epsilon = 2, tau = 0), iter = 1000)
}
