% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operating_characteristics.R
\name{ecd}
\alias{ecd}
\title{Calculate the Expected Number of Correct Decisions for a Basket Trial Design}
\usage{
ecd(
  design,
  n,
  p1,
  lambda,
  design_params = list(),
  iter = 1000,
  data = NULL,
  ...
)
}
\arguments{
\item{design}{An object created with one of the \code{setup} functions.}

\item{n}{The sample size per basket.}

\item{p1}{Probabilities used for the simulation. If \code{NULL}
then all probabilities are set to p0.}

\item{lambda}{The posterior probability threshold.}

\item{design_params}{A list of params that is specific to the class of
\code{design}.}

\item{iter}{The number of iterations in the simulation. Is ignored if
\code{data} is specified.}

\item{data}{A data matrix with k column with the number of responses for each
basket. Has to be generated with \code{get_data}. If \code{data} is used,
then \code{iter} is ignored.}

\item{...}{Further arguments.}
}
\value{
A numeric value.
}
\description{
Calculate the Expected Number of Correct Decisions for a Basket Trial Design
}
\examples{
# Example for a basket trial with Fujikawa's Design
design <- setup_fujikawa(k = 3, p0 = 0.2)
ecd(design = design, n = 20, p1 = c(0.2, 0.5, 0.5), lambda = 0.95,
  design_params = list(epsilon = 2, tau = 0), iter = 1000)
}
