% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_data}
\alias{get_data}
\title{Simulate Data Based on a Binomial Distribution}
\usage{
get_data(k, n, p, iter, type = c("matrix", "bhmbasket"))
}
\arguments{
\item{k}{The number of baskets.}

\item{n}{The sample size per basket.}

\item{p}{Probabilities used to simulate the data}

\item{iter}{The number of iterations in the simulation. Is ignored if
\code{data} is specified.}

\item{type}{Type of output. Use \code{bhmbasket} for the BHM and EXNED
design and \code{matrix} for everything else.}
}
\value{
If \code{type = "matrix"} then a matrix is returned, if
\code{type = "bhmbasket"} then an element with class \code{scenario_list}.
}
\description{
Simulate Data Based on a Binomial Distribution
}
\details{
For \code{type = "bhmbasket"} this is simply a wraper for
\code{bhmbasket::simulateScenarios}.
}
\examples{
get_data(k = 3, n = 20, p = c(0.2, 0.2, 0.5), iter = 1000)
}
