% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{jntCBOM}
\alias{jntCBOM}
\title{Montiel Olea and Plagborg-Moller (2018) confidence bands}
\usage{
jntCBOM(DF, DFmat, alpha = 0.05, eps = 0.001)
}
\arguments{
\item{DF}{the target distribution/quantile function as a vector}

\item{DFmat}{the matrix of draws of the distribution, rows correspond to 
indices elements in \code{DF}}

\item{alpha}{level such that \code{1-alpha} is the desired probability of coverage}

\item{eps}{steps by which the grid on 1-alpha:alpha/2 is searched.}
}
\value{
CB - confidence band, zeta - the optimal level
}
\description{
\code{jntCBOM} implements calibrated symmetric confidence bands (algorithm 2)
in Montiel Olea and Plagborg-Moller (2018).
}
\examples{
set.seed(14); m=matrix(rbeta(500,1,4),nrow = 5) + 1:5
DF = apply(m,1,mean); plot(1:5,DF,type="l",ylim = c(min(m),max(m)), xlab = "Index")
jOMCB<- jntCBOM(DF,DFmat = m)
lines(1:5,jOMCB$CB[,1],lty=2); lines(1:5,jOMCB$CB[,2],lty=2)

}
