% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{posterior}
\alias{posterior}
\title{Posterior distribution}
\usage{
posterior(pars, data, Log = TRUE, mu = 0, sig = 25,
  prior = "Normal")
}
\arguments{
\item{pars}{parameter values}

\item{data}{dataframe. The first column must be the binary dependent variable}

\item{Log}{logical to take the log of the posterior.(defaults to TRUE)}

\item{mu}{mean of prior of each parameter value in case the prior is Normal (default: 0)}

\item{sig}{standard deviation of prior of each parameter in case the prior is Normal 
(default: 25)}

\item{prior}{string input of "Normal" or "Uniform" prior distribution to use}
}
\value{
val value function of the posterior
}
\description{
\code{posterior} computes the value of the posterior at parameter values \code{pars}
}
\examples{
y = indicat(faithful$waiting,mean(faithful$waiting)) 
x = scale(cbind(faithful$eruptions,faithful$eruptions^2))
data = data.frame(y,x)
posterior(rep(0,3),data,Log = FALSE,mu=0,sig = 10,prior = "Normal") # no log
posterior(rep(0,3),data,Log = TRUE,mu=0,sig = 10,prior = "Normal") # log
posterior(rep(0,3),data,Log = TRUE) # use default values

}
