% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{p_adjust}
\alias{p_adjust}
\title{Adjust P-values for Multiple Comparisons}
\usage{
p_adjust(p, method = "oleson", n = length(p), alpha = 0.05, df, rho, cores = 0)
}
\arguments{
\item{p}{numeric vector of p-values (possibly with NAs).}

\item{method}{correction method, a character string. Can be any of the methods in
p.adjust.methods, with the additional value \code{method = "oleson"}}

\item{n}{number of comparisons, must be at least \code{length(p)}; only set this
(to non-default) when you know what you are doing!}

\item{alpha}{adjustment to be made with method oleson}

\item{df}{degrees of freedom, if using \code{method = "oleson"}}

\item{rho}{AR1 correlation coefficient, if using \code{method = "oleson"}}

\item{cores}{number of cores for use in parallel, only valid for
\code{method = "oleson"}. Default is zero, using half of the available cores}
}
\value{
Returns a vector of adjusted p-values just as in \code{p.adjust}, but
with additional attributes for alphastar and rho.
}
\description{
Identical to \code{stats::p.adjust}, but includes \code{method = "oleson"}
}
\details{
This function works identically to the function \code{p.adjust}, with
the additional option to use \code{method = "oleson"}. For this option, user
must include a value for \code{df}, \code{alpha}. If \code{method = "oleson"} and
no value is given for \code{rho}, 0.9 will be used. To compute a value for \code{rho}
from t-statistics, use \code{ar1Solver}.
}
\seealso{
\code{\link[bdots]{ar1Solver}}
}
