% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{pBetaBinom}
\alias{pBetaBinom}
\title{Cumulative Probability Function under the Beta-Binomial Probability Distribution.}
\usage{
pBetaBinom(q, N, l, u, alpha, beta, lower.tail = TRUE)
}
\arguments{
\item{q}{The quantile or a vector of quantiles for which the proportion is to be calculated.}

\item{N}{The total number of trials.}

\item{l}{The first (lower) location parameter.}

\item{u}{The second (upper) location parameter.}

\item{alpha}{The first shape parameter.}

\item{beta}{The second shape parameter.}

\item{lower.tail}{Whether the proportion to be calculated is to be under the lower or upper tail. Default is \code{TRUE} (lower tail).}
}
\value{
A vector of proportions of observations falling under specified quantiles under the four-parameter Beta distribution.
}
\description{
Function for calculating the proportion of observations up to a specifiable quantile under the Beta-Binomial Probability Distribution.
}
\examples{
# Assume some variable follows a Beta-Binomial distribution with number of
# trials = 50, and probabilities of successful trials are drawn from a four-
# parameter Beta distribution with location parameters l = 0.25 and u =
# 0.75, and shape parameters alpha = 5 and beta = 3. To compute the
# cumulative probability at a specific point of the distribution (e.g., 25):
pBetaBinom(q = 25, N = 50, l = .25, u = .75, alpha = 5, beta = 3)
}
