% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_bioregions.R
\name{map_bioregions}
\alias{map_bioregions}
\title{Create a map of bioregions}
\usage{
map_bioregions(clusters, geometry, write_clusters = FALSE, plot = TRUE, ...)
}
\arguments{
\item{clusters}{An object of class \code{bioregion.clusters} or a \code{data.frame}.
If a \code{data.frame} is used, the first column should represent the sites'
ID, and the subsequent column(s) should represent the clusters.}

\item{geometry}{A spatial object that can be handled by the \code{sf} package.
The first attribute should correspond to the sites' ID (see Details).}

\item{write_clusters}{A \code{boolean} indicating if the \code{clusters} should be
added to the \code{geometry}.}

\item{plot}{A \code{boolean} indicating if the plot should be drawn.}

\item{...}{Further arguments to be passed to \code{sf::plot()}.}
}
\value{
One or several maps of bioregions if \code{plot = TRUE} and the
geometry with additional clusters' attributes if \code{write_clusters = TRUE}.
}
\description{
This plot function can be used to visualize bioregions based on a
\code{bioregion.clusters} object combined with a geometry (\code{sf} objects).
}
\details{
The \code{clusters} and \code{geometry} site IDs should correspond. They should
have the same type (i.e., \code{character} if \code{clusters} is a
\code{bioregion.clusters} object) and the sites of \code{clusters} should be
included in the sites of \code{geometry}.
}
\examples{
data(fishmat)
data(fishsf)

net <- similarity(fishmat, metric = "Simpson")
clu <- netclu_greedy(net)
map <- map_bioregions(clu, fishsf, write_clusters = TRUE, plot = FALSE)

}
\author{
Maxime Lenormand (\email{maxime.lenormand@inrae.fr}) \cr
Boris Leroy (\email{leroy.boris@gmail.com}) \cr
Pierre Denelle (\email{pierre.denelle@gmail.com})
}
