% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mat_to_net.R
\name{mat_to_net}
\alias{mat_to_net}
\title{Create a data.frame from a contingency table}
\usage{
mat_to_net(
  mat,
  weight = FALSE,
  remove_zeroes = TRUE,
  include_diag = TRUE,
  include_lower = TRUE
)
}
\arguments{
\item{mat}{A contingency table (i.e., a \code{matrix}).}

\item{weight}{A \code{logical} value indicating whether the values in the matrix
should be interpreted as interaction weights.}

\item{remove_zeroes}{A \code{logical} value determining whether interactions with
a weight equal to 0 should be excluded from the output.}

\item{include_diag}{A \code{logical} value indicating whether the diagonal
(self-interactions) should be included in the output. This applies only to
square matrices.}

\item{include_lower}{A \code{logical} value indicating whether the lower
triangular part of the \code{matrix} should be included in the output. This
applies only to square matrices.}
}
\value{
A \code{data.frame} where each row represents the interaction
between two nodes. If \code{weight = TRUE}, the \code{data.frame} includes a third
column representing the weight of each interaction.
}
\description{
This function generates a two- or three-column \code{data.frame}, where
each row represents the interaction between two nodes (e.g., site and species)
and an optional third column indicates the weight of the interaction
(if \code{weight = TRUE}). The input is a contingency table, with rows
representing one set of entities (e.g., site) and columns representing
another set (e.g., species).
}
\examples{
mat <- matrix(sample(1000, 50), 5, 10)
rownames(mat) <- paste0("Site", 1:5)
colnames(mat) <- paste0("Species", 1:10)

net <- mat_to_net(mat, weight = TRUE)

}
\seealso{
For more details illustrated with a practical example,
see the vignette:
\url{https://biorgeo.github.io/bioregion/articles/a2_matrix_and_network_formats.html}.

Associated functions:
\link{net_to_mat}
}
\author{
Maxime Lenormand (\email{maxime.lenormand@inrae.fr}) \cr
Pierre Denelle (\email{pierre.denelle@gmail.com}) \cr
Boris Leroy (\email{leroy.boris@gmail.com})
}
