% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResultsFollowupAnalysisAndPlotting.R
\name{GetMarginalPosteriors}
\alias{GetMarginalPosteriors}
\title{Get Marginal \{\bold{U},\bold{D},\bold{I}\} Posteriors}
\usage{
GetMarginalPosteriors(DataSources, ListSNPs, Models, LogFile)
}
\arguments{
\item{DataSources}{A string indicating the variable names of the
input datafiles and phenotypes.}

\item{ListSNPs}{A list produced from running \code{\link{bmass}} 
containing the SNPs of interest to get marginal posteriors for.}

\item{Models}{A matrix describing the models being explored
(default output from running \code{\link{bmass}}).}

\item{LogFile}{A matrix of string outputs for function logging
purposes (default output from running \code{\link{bmass}}).}
}
\value{
A list containing three matrices of SNPs x Phenotypes
marginal posteriors for each category \{\bold{U},\bold{D},\bold{I}\}; 
this list is appended to the input ListSNPs as a new object, 
\code{Marginals} (the full returned object is a list containing the 
input ListSNPs and the input LogFile).
}
\description{
Get marginal posteriors for how much every individual
phenotype belongs to categories \{\bold{U},\bold{D},\bold{I}\} 
across each SNP
}
\examples{
Phenotypes <- c("bmass_SimulatedData1", "bmass_SimulatedData2")
bmassOutput <- bmass(Phenotypes, bmass_SimulatedSigSNPs)
bmassOutput[c("PreviousSNPs", "LogFile")] <-
GetMarginalPosteriors(Phenotypes, bmassOutput$PreviousSNPs,
bmassOutput$Models, bmassOutput$LogFile)
bmassOutput$PreviousSNPs$Marginals

}
