// Generated by rstantools.  Do not edit by hand.

/*
    bmgarch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bmgarch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bmgarch.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_BEKKMGARCH_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'BEKKMGARCH', line 57, column 0 to column 16)",
                                                      " (in 'BEKKMGARCH', line 62, column 0 to column 41)",
                                                      " (in 'BEKKMGARCH', line 63, column 0 to column 43)",
                                                      " (in 'BEKKMGARCH', line 66, column 2 to column 23)",
                                                      " (in 'BEKKMGARCH', line 67, column 2 to column 19)",
                                                      " (in 'BEKKMGARCH', line 71, column 2 to column 22)",
                                                      " (in 'BEKKMGARCH', line 72, column 2 to column 32)",
                                                      " (in 'BEKKMGARCH', line 73, column 2 to column 32)",
                                                      " (in 'BEKKMGARCH', line 75, column 2 to column 25)",
                                                      " (in 'BEKKMGARCH', line 76, column 2 to column 23)",
                                                      " (in 'BEKKMGARCH', line 79, column 2 to column 28)",
                                                      " (in 'BEKKMGARCH', line 80, column 2 to column 30)",
                                                      " (in 'BEKKMGARCH', line 81, column 2 to column 25)",
                                                      " (in 'BEKKMGARCH', line 82, column 2 to column 60)",
                                                      " (in 'BEKKMGARCH', line 83, column 2 to column 60)",
                                                      " (in 'BEKKMGARCH', line 84, column 2 to column 66)",
                                                      " (in 'BEKKMGARCH', line 85, column 2 to column 22)",
                                                      " (in 'BEKKMGARCH', line 86, column 2 to column 22)",
                                                      " (in 'BEKKMGARCH', line 89, column 2 to column 16)",
                                                      " (in 'BEKKMGARCH', line 90, column 2 to column 18)",
                                                      " (in 'BEKKMGARCH', line 102, column 2 to column 36)",
                                                      " (in 'BEKKMGARCH', line 100, column 32 to line 103, column 2)",
                                                      " (in 'BEKKMGARCH', line 100, column 8 to line 103, column 2)",
                                                      " (in 'BEKKMGARCH', line 99, column 2 to column 71)",
                                                      " (in 'BEKKMGARCH', line 97, column 32 to line 100, column 2)",
                                                      " (in 'BEKKMGARCH', line 97, column 8 to line 103, column 2)",
                                                      " (in 'BEKKMGARCH', line 96, column 2 to column 17)",
                                                      " (in 'BEKKMGARCH', line 94, column 24 to line 97, column 2)",
                                                      " (in 'BEKKMGARCH', line 94, column 0 to line 103, column 2)",
                                                      " (in 'BEKKMGARCH', line 105, column 4 to column 47)",
                                                      " (in 'BEKKMGARCH', line 106, column 4 to column 47)",
                                                      " (in 'BEKKMGARCH', line 109, column 6 to column 68)",
                                                      " (in 'BEKKMGARCH', line 110, column 6 to column 56)",
                                                      " (in 'BEKKMGARCH', line 108, column 31 to line 111, column 5)",
                                                      " (in 'BEKKMGARCH', line 108, column 4 to line 111, column 5)",
                                                      " (in 'BEKKMGARCH', line 113, column 6 to column 55)",
                                                      " (in 'BEKKMGARCH', line 112, column 31 to line 114, column 5)",
                                                      " (in 'BEKKMGARCH', line 112, column 4 to line 114, column 5)",
                                                      " (in 'BEKKMGARCH', line 120, column 6 to column 53)",
                                                      " (in 'BEKKMGARCH', line 121, column 6 to column 41)",
                                                      " (in 'BEKKMGARCH', line 122, column 6 to column 39)",
                                                      " (in 'BEKKMGARCH', line 119, column 31 to line 123, column 5)",
                                                      " (in 'BEKKMGARCH', line 119, column 11 to line 123, column 5)",
                                                      " (in 'BEKKMGARCH', line 116, column 6 to column 26)",
                                                      " (in 'BEKKMGARCH', line 117, column 6 to column 41)",
                                                      " (in 'BEKKMGARCH', line 118, column 6 to column 38)",
                                                      " (in 'BEKKMGARCH', line 115, column 25 to line 119, column 5)",
                                                      " (in 'BEKKMGARCH', line 115, column 4 to line 123, column 5)",
                                                      " (in 'BEKKMGARCH', line 91, column 16 to line 124, column 3)",
                                                      " (in 'BEKKMGARCH', line 91, column 2 to line 124, column 3)",
                                                      " (in 'BEKKMGARCH', line 160, column 2 to column 36)",
                                                      " (in 'BEKKMGARCH', line 161, column 2 to column 36)",
                                                      " (in 'BEKKMGARCH', line 162, column 2 to column 23)",
                                                      " (in 'BEKKMGARCH', line 163, column 2 to column 24)",
                                                      " (in 'BEKKMGARCH', line 164, column 2 to column 23)",
                                                      " (in 'BEKKMGARCH', line 165, column 2 to column 32)",
                                                      " (in 'BEKKMGARCH', line 166, column 2 to column 23)",
                                                      " (in 'BEKKMGARCH', line 169, column 6 to column 19)",
                                                      " (in 'BEKKMGARCH', line 168, column 21 to line 170, column 5)",
                                                      " (in 'BEKKMGARCH', line 168, column 4 to line 170, column 5)",
                                                      " (in 'BEKKMGARCH', line 167, column 16 to line 171, column 3)",
                                                      " (in 'BEKKMGARCH', line 167, column 2 to line 171, column 3)",
                                                      " (in 'BEKKMGARCH', line 174, column 6 to column 19)",
                                                      " (in 'BEKKMGARCH', line 173, column 21 to line 175, column 5)",
                                                      " (in 'BEKKMGARCH', line 173, column 4 to line 175, column 5)",
                                                      " (in 'BEKKMGARCH', line 172, column 16 to line 176, column 3)",
                                                      " (in 'BEKKMGARCH', line 172, column 2 to line 176, column 3)",
                                                      " (in 'BEKKMGARCH', line 178, column 2 to column 13)",
                                                      " (in 'BEKKMGARCH', line 179, column 2 to column 24)",
                                                      " (in 'BEKKMGARCH', line 191, column 4 to column 57)",
                                                      " (in 'BEKKMGARCH', line 192, column 4 to column 30)",
                                                      " (in 'BEKKMGARCH', line 193, column 4 to column 67)",
                                                      " (in 'BEKKMGARCH', line 190, column 17 to line 194, column 3)",
                                                      " (in 'BEKKMGARCH', line 190, column 2 to line 194, column 3)",
                                                      " (in 'BEKKMGARCH', line 189, column 33 to line 195, column 2)",
                                                      " (in 'BEKKMGARCH', line 189, column 8 to line 195, column 2)",
                                                      " (in 'BEKKMGARCH', line 185, column 4 to column 50)",
                                                      " (in 'BEKKMGARCH', line 186, column 4 to column 30)",
                                                      " (in 'BEKKMGARCH', line 187, column 4 to column 60)",
                                                      " (in 'BEKKMGARCH', line 184, column 17 to line 188, column 3)",
                                                      " (in 'BEKKMGARCH', line 184, column 2 to line 188, column 3)",
                                                      " (in 'BEKKMGARCH', line 183, column 24 to line 189, column 2)",
                                                      " (in 'BEKKMGARCH', line 183, column 0 to line 195, column 2)",
                                                      " (in 'BEKKMGARCH', line 130, column 2 to column 24)",
                                                      " (in 'BEKKMGARCH', line 132, column 2 to column 65)",
                                                      " (in 'BEKKMGARCH', line 133, column 2 to column 34)",
                                                      " (in 'BEKKMGARCH', line 134, column 2 to column 32)",
                                                      " (in 'BEKKMGARCH', line 136, column 2 to column 53)",
                                                      " (in 'BEKKMGARCH', line 137, column 2 to column 34)",
                                                      " (in 'BEKKMGARCH', line 138, column 2 to column 34)",
                                                      " (in 'BEKKMGARCH', line 139, column 2 to column 22)",
                                                      " (in 'BEKKMGARCH', line 141, column 4 to column 39)",
                                                      " (in 'BEKKMGARCH', line 140, column 16 to line 142, column 3)",
                                                      " (in 'BEKKMGARCH', line 140, column 2 to line 142, column 3)",
                                                      " (in 'BEKKMGARCH', line 144, column 4 to column 39)",
                                                      " (in 'BEKKMGARCH', line 143, column 16 to line 145, column 3)",
                                                      " (in 'BEKKMGARCH', line 143, column 2 to line 145, column 3)",
                                                      " (in 'BEKKMGARCH', line 154, column 6 to column 68)",
                                                      " (in 'BEKKMGARCH', line 153, column 17 to line 155, column 5)",
                                                      " (in 'BEKKMGARCH', line 153, column 4 to line 155, column 5)",
                                                      " (in 'BEKKMGARCH', line 152, column 34 to line 156, column 3)",
                                                      " (in 'BEKKMGARCH', line 152, column 9 to line 156, column 3)",
                                                      " (in 'BEKKMGARCH', line 150, column 6 to column 59)",
                                                      " (in 'BEKKMGARCH', line 149, column 17 to line 151, column 5)",
                                                      " (in 'BEKKMGARCH', line 149, column 4 to line 151, column 5)",
                                                      " (in 'BEKKMGARCH', line 148, column 27 to line 152, column 3)",
                                                      " (in 'BEKKMGARCH', line 148, column 2 to line 156, column 3)",
                                                      " (in 'BEKKMGARCH', line 15, column 0 to column 15)",
                                                      " (in 'BEKKMGARCH', line 16, column 0 to column 16)",
                                                      " (in 'BEKKMGARCH', line 17, column 0 to column 15)",
                                                      " (in 'BEKKMGARCH', line 18, column 0 to column 15)",
                                                      " (in 'BEKKMGARCH', line 19, column 6 to column 7)",
                                                      " (in 'BEKKMGARCH', line 19, column 16 to column 18)",
                                                      " (in 'BEKKMGARCH', line 19, column 0 to column 24)",
                                                      " (in 'BEKKMGARCH', line 20, column 6 to column 7)",
                                                      " (in 'BEKKMGARCH', line 20, column 16 to column 18)",
                                                      " (in 'BEKKMGARCH', line 20, column 0 to column 23)",
                                                      " (in 'BEKKMGARCH', line 21, column 0 to column 35)",
                                                      " (in 'BEKKMGARCH', line 22, column 0 to column 36)",
                                                      " (in 'BEKKMGARCH', line 26, column 9 to column 11)",
                                                      " (in 'BEKKMGARCH', line 26, column 2 to column 19)",
                                                      " (in 'BEKKMGARCH', line 27, column 9 to column 11)",
                                                      " (in 'BEKKMGARCH', line 27, column 2 to column 20)",
                                                      " (in 'BEKKMGARCH', line 30, column 6 to column 7)",
                                                      " (in 'BEKKMGARCH', line 30, column 16 to column 18)",
                                                      " (in 'BEKKMGARCH', line 30, column 20 to column 22)",
                                                      " (in 'BEKKMGARCH', line 30, column 0 to column 29)",
                                                      " (in 'BEKKMGARCH', line 31, column 0 to column 29)",
                                                      " (in 'BEKKMGARCH', line 32, column 0 to column 19)",
                                                      " (in 'BEKKMGARCH', line 35, column 2 to column 33)",
                                                      " (in 'BEKKMGARCH', line 37, column 2 to column 33)",
                                                      " (in 'BEKKMGARCH', line 39, column 4 to column 30)",
                                                      " (in 'BEKKMGARCH', line 38, column 2 to line 39, column 30)",
                                                      " (in 'BEKKMGARCH', line 34, column 15 to line 40, column 2)",
                                                      " (in 'BEKKMGARCH', line 34, column 0 to line 40, column 2)",
                                                      " (in 'BEKKMGARCH', line 49, column 1 to column 21)",
                                                      " (in 'BEKKMGARCH', line 50, column 1 to column 25)",
                                                      " (in 'BEKKMGARCH', line 48, column 23 to line 51, column 7)",
                                                      " (in 'BEKKMGARCH', line 48, column 6 to line 51, column 7)",
                                                      " (in 'BEKKMGARCH', line 46, column 55 to line 52, column 5)",
                                                      " (in 'BEKKMGARCH', line 46, column 9 to line 52, column 5)",
                                                      " (in 'BEKKMGARCH', line 43, column 6 to column 31)",
                                                      " (in 'BEKKMGARCH', line 44, column 6 to column 30)",
                                                      " (in 'BEKKMGARCH', line 42, column 21 to line 45, column 5)",
                                                      " (in 'BEKKMGARCH', line 42, column 4 to line 45, column 5)",
                                                      " (in 'BEKKMGARCH', line 41, column 26 to line 46, column 3)",
                                                      " (in 'BEKKMGARCH', line 41, column 2 to line 52, column 5)",
                                                      " (in 'BEKKMGARCH', line 57, column 7 to column 9)",
                                                      " (in 'BEKKMGARCH', line 62, column 30 to column 32)",
                                                      " (in 'BEKKMGARCH', line 62, column 33 to column 35)",
                                                      " (in 'BEKKMGARCH', line 63, column 30 to column 32)",
                                                      " (in 'BEKKMGARCH', line 63, column 33 to column 35)",
                                                      " (in 'BEKKMGARCH', line 66, column 13 to column 15)",
                                                      " (in 'BEKKMGARCH', line 67, column 9 to column 11)",
                                                      " (in 'BEKKMGARCH', line 71, column 14 to column 16)",
                                                      " (in 'BEKKMGARCH', line 72, column 8 to column 9)",
                                                      " (in 'BEKKMGARCH', line 72, column 18 to column 20)",
                                                      " (in 'BEKKMGARCH', line 72, column 22 to column 24)",
                                                      " (in 'BEKKMGARCH', line 73, column 8 to column 9)",
                                                      " (in 'BEKKMGARCH', line 73, column 18 to column 20)",
                                                      " (in 'BEKKMGARCH', line 73, column 22 to column 24)",
                                                      " (in 'BEKKMGARCH', line 75, column 13 to column 15)",
                                                      " (in 'BEKKMGARCH', line 79, column 8 to column 9)",
                                                      " (in 'BEKKMGARCH', line 79, column 22 to column 24)",
                                                      " (in 'BEKKMGARCH', line 80, column 8 to column 11)",
                                                      " (in 'BEKKMGARCH', line 80, column 20 to column 22)",
                                                      " (in 'BEKKMGARCH', line 80, column 23 to column 25)",
                                                      " (in 'BEKKMGARCH', line 81, column 8 to column 9)",
                                                      " (in 'BEKKMGARCH', line 81, column 18 to column 20)",
                                                      " (in 'BEKKMGARCH', line 82, column 9 to column 11)",
                                                      " (in 'BEKKMGARCH', line 82, column 13 to column 15)",
                                                      " (in 'BEKKMGARCH', line 83, column 9 to column 11)",
                                                      " (in 'BEKKMGARCH', line 83, column 13 to column 15)",
                                                      " (in 'BEKKMGARCH', line 84, column 9 to column 13)",
                                                      " (in 'BEKKMGARCH', line 84, column 15 to column 17)",
                                                      " (in 'BEKKMGARCH', line 85, column 13 to column 15)",
                                                      " (in 'BEKKMGARCH', line 86, column 13 to column 15)",
                                                      " (in 'BEKKMGARCH', line 160, column 8 to column 9)",
                                                      " (in 'BEKKMGARCH', line 160, column 18 to column 20)",
                                                      " (in 'BEKKMGARCH', line 160, column 22 to column 24)",
                                                      " (in 'BEKKMGARCH', line 161, column 8 to column 9)",
                                                      " (in 'BEKKMGARCH', line 161, column 18 to column 20)",
                                                      " (in 'BEKKMGARCH', line 161, column 22 to column 24)",
                                                      " (in 'BEKKMGARCH', line 162, column 9 to column 11)",
                                                      " (in 'BEKKMGARCH', line 162, column 12 to column 13)",
                                                      " (in 'BEKKMGARCH', line 163, column 8 to column 9)",
                                                      " (in 'BEKKMGARCH', line 164, column 14 to column 16)",
                                                      " (in 'BEKKMGARCH', line 165, column 8 to column 9)",
                                                      " (in 'BEKKMGARCH', line 165, column 23 to column 25)",
                                                      " (in 'BEKKMGARCH', line 166, column 13 to column 15)",
                                                      " (in 'BEKKMGARCH', line 5, column 4 to column 21)",
                                                      " (in 'BEKKMGARCH', line 6, column 11 to column 13)",
                                                      " (in 'BEKKMGARCH', line 6, column 14 to column 16)",
                                                      " (in 'BEKKMGARCH', line 6, column 4 to column 20)",
                                                      " (in 'BEKKMGARCH', line 7, column 11 to column 13)",
                                                      " (in 'BEKKMGARCH', line 7, column 14 to column 16)",
                                                      " (in 'BEKKMGARCH', line 7, column 4 to column 20)",
                                                      " (in 'BEKKMGARCH', line 8, column 4 to column 46)",
                                                      " (in 'BEKKMGARCH', line 9, column 4 to column 15)",
                                                      " (in 'BEKKMGARCH', line 10, column 4 to column 13)",
                                                      " (in 'BEKKMGARCH', line 4, column 24 to line 11, column 1)"};
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, -1>
cov2cor(const T0__& C_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>>;
  const auto& C = to_ref(C_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int dm;
    dm = std::numeric_limits<int>::min();
    
    current_statement__ = 191;
    dm = rows(C);
    current_statement__ = 192;
    validate_non_negative_index("s", "dm", dm);
    current_statement__ = 193;
    validate_non_negative_index("s", "dm", dm);
    Eigen::Matrix<local_scalar_t__, -1, -1> s;
    s = Eigen::Matrix<local_scalar_t__, -1, -1>(dm, dm);
    stan::math::fill(s, DUMMY_VAR__);
    
    current_statement__ = 195;
    validate_non_negative_index("R", "dm", dm);
    current_statement__ = 196;
    validate_non_negative_index("R", "dm", dm);
    Eigen::Matrix<local_scalar_t__, -1, -1> R;
    R = Eigen::Matrix<local_scalar_t__, -1, -1>(dm, dm);
    stan::math::fill(R, DUMMY_VAR__);
    
    current_statement__ = 198;
    assign(s, nil_index_list(),
      diag_matrix(elt_divide(1, stan::math::sqrt(diagonal(C)))),
      "assigning variable s");
    current_statement__ = 199;
    assign(R, nil_index_list(), multiply(multiply(s, C), s),
      "assigning variable R");
    current_statement__ = 200;
    return R;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct cov2cor_functor__ {
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, -1>
operator()(const T0__& C, std::ostream* pstream__)  const 
{
return cov2cor(C, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_BEKKMGARCH final : public model_base_crtp<model_BEKKMGARCH> {
private:
  int T;
  int nt;
  int Q;
  int P;
  std::vector<Eigen::Matrix<double, -1, 1>> rts;
  std::vector<Eigen::Matrix<double, -1, 1>> xC;
  int distribution;
  int meanstructure;
  Eigen::Matrix<double, -1, 1> rts_m;
  Eigen::Matrix<double, -1, 1> rts_sd;
  std::vector<Eigen::Matrix<double, -1, -1>> xC_m;
  int xC_marker;
  double cp;
  int rr_1dim__;
  int beta_1dim__;
 
public:
  ~model_BEKKMGARCH() { }
  
  inline std::string model_name() const final { return "model_BEKKMGARCH"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_BEKKMGARCH(stan::io::var_context& context__,
                   unsigned int random_seed__ = 0,
                   std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_BEKKMGARCH_namespace::model_BEKKMGARCH";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 108;
      context__.validate_dims("data initialization","T","int",
          context__.to_vec());
      T = std::numeric_limits<int>::min();
      
      current_statement__ = 108;
      T = context__.vals_i("T")[(1 - 1)];
      current_statement__ = 108;
      current_statement__ = 108;
      check_greater_or_equal(function__, "T", T, 2);
      current_statement__ = 109;
      context__.validate_dims("data initialization","nt","int",
          context__.to_vec());
      nt = std::numeric_limits<int>::min();
      
      current_statement__ = 109;
      nt = context__.vals_i("nt")[(1 - 1)];
      current_statement__ = 109;
      current_statement__ = 109;
      check_greater_or_equal(function__, "nt", nt, 2);
      current_statement__ = 110;
      context__.validate_dims("data initialization","Q","int",
          context__.to_vec());
      Q = std::numeric_limits<int>::min();
      
      current_statement__ = 110;
      Q = context__.vals_i("Q")[(1 - 1)];
      current_statement__ = 110;
      current_statement__ = 110;
      check_greater_or_equal(function__, "Q", Q, 1);
      current_statement__ = 111;
      context__.validate_dims("data initialization","P","int",
          context__.to_vec());
      P = std::numeric_limits<int>::min();
      
      current_statement__ = 111;
      P = context__.vals_i("P")[(1 - 1)];
      current_statement__ = 111;
      current_statement__ = 111;
      check_greater_or_equal(function__, "P", P, 1);
      current_statement__ = 112;
      validate_non_negative_index("rts", "T", T);
      current_statement__ = 113;
      validate_non_negative_index("rts", "nt", nt);
      current_statement__ = 114;
      context__.validate_dims("data initialization","rts","double",
          context__.to_vec(T, nt));
      rts = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(rts, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> rts_flat__;
        current_statement__ = 114;
        assign(rts_flat__, nil_index_list(), context__.vals_r("rts"),
          "assigning variable rts_flat__");
        current_statement__ = 114;
        pos__ = 1;
        current_statement__ = 114;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 114;
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            current_statement__ = 114;
            assign(rts,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              rts_flat__[(pos__ - 1)], "assigning variable rts");
            current_statement__ = 114;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 115;
      validate_non_negative_index("xC", "T", T);
      current_statement__ = 116;
      validate_non_negative_index("xC", "nt", nt);
      current_statement__ = 117;
      context__.validate_dims("data initialization","xC","double",
          context__.to_vec(T, nt));
      xC = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(xC, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> xC_flat__;
        current_statement__ = 117;
        assign(xC_flat__, nil_index_list(), context__.vals_r("xC"),
          "assigning variable xC_flat__");
        current_statement__ = 117;
        pos__ = 1;
        current_statement__ = 117;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 117;
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            current_statement__ = 117;
            assign(xC,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              xC_flat__[(pos__ - 1)], "assigning variable xC");
            current_statement__ = 117;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 118;
      context__.validate_dims("data initialization","distribution","int",
          context__.to_vec());
      distribution = std::numeric_limits<int>::min();
      
      current_statement__ = 118;
      distribution = context__.vals_i("distribution")[(1 - 1)];
      current_statement__ = 118;
      current_statement__ = 118;
      check_greater_or_equal(function__, "distribution", distribution, 0);
      current_statement__ = 118;
      current_statement__ = 118;
      check_less_or_equal(function__, "distribution", distribution, 1);
      current_statement__ = 119;
      context__.validate_dims("data initialization","meanstructure","int",
          context__.to_vec());
      meanstructure = std::numeric_limits<int>::min();
      
      current_statement__ = 119;
      meanstructure = context__.vals_i("meanstructure")[(1 - 1)];
      current_statement__ = 119;
      current_statement__ = 119;
      check_greater_or_equal(function__, "meanstructure", meanstructure, 0);
      current_statement__ = 119;
      current_statement__ = 119;
      check_less_or_equal(function__, "meanstructure", meanstructure, 2);
      current_statement__ = 120;
      validate_non_negative_index("rts_m", "nt", nt);
      current_statement__ = 121;
      rts_m = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(rts_m, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 122;
      validate_non_negative_index("rts_sd", "nt", nt);
      current_statement__ = 123;
      rts_sd = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(rts_sd, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 124;
      validate_non_negative_index("xC_m", "T", T);
      current_statement__ = 125;
      validate_non_negative_index("xC_m", "nt", nt);
      current_statement__ = 126;
      validate_non_negative_index("xC_m", "nt", nt);
      current_statement__ = 127;
      xC_m = std::vector<Eigen::Matrix<double, -1, -1>>(T, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(xC_m, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 128;
      xC_marker = std::numeric_limits<int>::min();
      
      current_statement__ = 128;
      xC_marker = 0;
      current_statement__ = 129;
      cp = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 135;
      for (int t = 1; t <= T; ++t) {
        current_statement__ = 130;
        assign(xC_m, cons_list(index_uni(t), nil_index_list()),
          diag_matrix(xC[(t - 1)]), "assigning variable xC_m");
        current_statement__ = 131;
        cp = sum(multiply(transpose(xC_m[(t - 1)]), xC_m[(t - 1)]));
        current_statement__ = 133;
        if (logical_neq(cp, 0)) {
          current_statement__ = 132;
          xC_marker = (xC_marker + 1);
        } }
      current_statement__ = 147;
      if (logical_eq(meanstructure, 0)) {
        current_statement__ = 145;
        for (int i = 1; i <= nt; ++i) {
          current_statement__ = 142;
          assign(rts_m, cons_list(index_uni(i), nil_index_list()),
            mean(
              rvalue(rts,
                cons_list(index_omni(),
                  cons_list(index_uni(i), nil_index_list())), "rts")),
            "assigning variable rts_m");
          current_statement__ = 143;
          assign(rts_sd, cons_list(index_uni(i), nil_index_list()),
            sd(
              rvalue(rts,
                cons_list(index_omni(),
                  cons_list(index_uni(i), nil_index_list())), "rts")),
            "assigning variable rts_sd");}
      } else {
        current_statement__ = 141;
        if ((primitive_value(logical_eq(meanstructure, 1)) ||
            primitive_value(logical_eq(meanstructure, 2)))) {
          current_statement__ = 139;
          for (int i = 1; i <= nt; ++i) {
            current_statement__ = 136;
            assign(rts_m, cons_list(index_uni(i), nil_index_list()),
              rts[(1 - 1)][(i - 1)], "assigning variable rts_m");
            current_statement__ = 137;
            assign(rts_sd, cons_list(index_uni(i), nil_index_list()),
              sd(
                rvalue(rts,
                  cons_list(index_omni(),
                    cons_list(index_uni(i), nil_index_list())), "rts")),
              "assigning variable rts_sd");}
        } 
      }
      current_statement__ = 128;
      current_statement__ = 128;
      check_greater_or_equal(function__, "xC_marker", xC_marker, 0);
      current_statement__ = 129;
      current_statement__ = 129;
      check_greater_or_equal(function__, "cp", cp, 0);
      current_statement__ = 148;
      validate_non_negative_index("phi0", "nt", nt);
      current_statement__ = 149;
      validate_non_negative_index("phi", "nt", nt);
      current_statement__ = 150;
      validate_non_negative_index("phi", "nt", nt);
      current_statement__ = 151;
      validate_non_negative_index("theta", "nt", nt);
      current_statement__ = 152;
      validate_non_negative_index("theta", "nt", nt);
      current_statement__ = 153;
      validate_non_negative_index("beta0", "nt", nt);
      current_statement__ = 154;
      validate_non_negative_index("beta1", "nt", nt);
      current_statement__ = 155;
      validate_non_negative_index("C_R", "nt", nt);
      current_statement__ = 155;
      validate_non_negative_index("C_R", "nt", nt);
      current_statement__ = 156;
      validate_non_negative_index("A_raw", "Q", Q);
      current_statement__ = 157;
      validate_non_negative_index("A_raw", "nt", nt);
      current_statement__ = 158;
      validate_non_negative_index("A_raw", "nt", nt);
      current_statement__ = 159;
      validate_non_negative_index("B_raw", "P", P);
      current_statement__ = 160;
      validate_non_negative_index("B_raw", "nt", nt);
      current_statement__ = 161;
      validate_non_negative_index("B_raw", "nt", nt);
      current_statement__ = 162;
      validate_non_negative_index("H1_init", "nt", nt);
      current_statement__ = 162;
      validate_non_negative_index("H1_init", "nt", nt);
      current_statement__ = 163;
      validate_non_negative_index("H", "T", T);
      current_statement__ = 164;
      validate_non_negative_index("H", "nt", nt);
      current_statement__ = 164;
      validate_non_negative_index("H", "nt", nt);
      current_statement__ = 165;
      rr_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 165;
      rr_1dim__ = (T - 1);
      current_statement__ = 165;
      validate_non_negative_index("rr", "T - 1", rr_1dim__);
      current_statement__ = 166;
      validate_non_negative_index("rr", "nt", nt);
      current_statement__ = 167;
      validate_non_negative_index("rr", "nt", nt);
      current_statement__ = 168;
      validate_non_negative_index("mu", "T", T);
      current_statement__ = 169;
      validate_non_negative_index("mu", "nt", nt);
      current_statement__ = 170;
      validate_non_negative_index("A_part", "nt", nt);
      current_statement__ = 171;
      validate_non_negative_index("A_part", "nt", nt);
      current_statement__ = 172;
      validate_non_negative_index("B_part", "nt", nt);
      current_statement__ = 173;
      validate_non_negative_index("B_part", "nt", nt);
      current_statement__ = 174;
      beta_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 174;
      beta_1dim__ = (nt + 1);
      current_statement__ = 174;
      validate_non_negative_index("beta", "nt + 1", beta_1dim__);
      current_statement__ = 175;
      validate_non_negative_index("beta", "nt", nt);
      current_statement__ = 176;
      validate_non_negative_index("C_sd", "nt", nt);
      current_statement__ = 177;
      validate_non_negative_index("Cnst", "nt", nt);
      current_statement__ = 177;
      validate_non_negative_index("Cnst", "nt", nt);
      current_statement__ = 178;
      validate_non_negative_index("A", "Q", Q);
      current_statement__ = 179;
      validate_non_negative_index("A", "nt", nt);
      current_statement__ = 180;
      validate_non_negative_index("A", "nt", nt);
      current_statement__ = 181;
      validate_non_negative_index("B", "P", P);
      current_statement__ = 182;
      validate_non_negative_index("B", "nt", nt);
      current_statement__ = 183;
      validate_non_negative_index("B", "nt", nt);
      current_statement__ = 184;
      validate_non_negative_index("rts_out", "nt", nt);
      current_statement__ = 185;
      validate_non_negative_index("rts_out", "T", T);
      current_statement__ = 186;
      validate_non_negative_index("log_lik", "T", T);
      current_statement__ = 187;
      validate_non_negative_index("corC", "nt", nt);
      current_statement__ = 187;
      validate_non_negative_index("corC", "nt", nt);
      current_statement__ = 188;
      validate_non_negative_index("corH", "T", T);
      current_statement__ = 189;
      validate_non_negative_index("corH", "nt", nt);
      current_statement__ = 189;
      validate_non_negative_index("corH", "nt", nt);
      current_statement__ = 190;
      validate_non_negative_index("C_var", "nt", nt);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += nt;
      num_params_r__ += nt * nt;
      num_params_r__ += nt * nt;
      num_params_r__ += nt;
      num_params_r__ += nt;
      num_params_r__ += ((nt * (nt - 1)) / 2);
      num_params_r__ += Q * nt * nt;
      num_params_r__ += P * nt * nt;
      num_params_r__ += (nt + ((nt * (nt - 1)) / 2));
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_BEKKMGARCH_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> phi0;
      phi0 = Eigen::Matrix<local_scalar_t__, -1, 1>(nt);
      stan::math::fill(phi0, DUMMY_VAR__);
      
      current_statement__ = 1;
      phi0 = in__.vector(nt);
      Eigen::Matrix<local_scalar_t__, -1, -1> phi;
      phi = Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt);
      stan::math::fill(phi, DUMMY_VAR__);
      
      current_statement__ = 2;
      phi = in__.matrix(nt, nt);
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 2;
          if (jacobian__) {
            current_statement__ = 2;
            assign(phi,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(
                rvalue(phi,
                  cons_list(index_uni(sym1__),
                    cons_list(index_uni(sym2__), nil_index_list())), "phi"),
                -1, 1, lp__), "assigning variable phi");
          } else {
            current_statement__ = 2;
            assign(phi,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(
                rvalue(phi,
                  cons_list(index_uni(sym1__),
                    cons_list(index_uni(sym2__), nil_index_list())), "phi"),
                -1, 1), "assigning variable phi");
          }}}
      Eigen::Matrix<local_scalar_t__, -1, -1> theta;
      theta = Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt);
      stan::math::fill(theta, DUMMY_VAR__);
      
      current_statement__ = 3;
      theta = in__.matrix(nt, nt);
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 3;
          if (jacobian__) {
            current_statement__ = 3;
            assign(theta,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(
                rvalue(theta,
                  cons_list(index_uni(sym1__),
                    cons_list(index_uni(sym2__), nil_index_list())), "theta"),
                -1, 1, lp__), "assigning variable theta");
          } else {
            current_statement__ = 3;
            assign(theta,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(
                rvalue(theta,
                  cons_list(index_uni(sym1__),
                    cons_list(index_uni(sym2__), nil_index_list())), "theta"),
                -1, 1), "assigning variable theta");
          }}}
      Eigen::Matrix<local_scalar_t__, 1, -1> beta0;
      beta0 = Eigen::Matrix<local_scalar_t__, 1, -1>(nt);
      stan::math::fill(beta0, DUMMY_VAR__);
      
      current_statement__ = 4;
      beta0 = in__.row_vector(nt);
      Eigen::Matrix<local_scalar_t__, -1, 1> beta1;
      beta1 = Eigen::Matrix<local_scalar_t__, -1, 1>(nt);
      stan::math::fill(beta1, DUMMY_VAR__);
      
      current_statement__ = 5;
      beta1 = in__.vector(nt);
      Eigen::Matrix<local_scalar_t__, -1, -1> C_R;
      C_R = Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt);
      stan::math::fill(C_R, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> C_R_in__;
      C_R_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>(((nt * (nt - 1)) / 2));
      stan::math::fill(C_R_in__, DUMMY_VAR__);
      
      current_statement__ = 6;
      C_R_in__ = in__.vector(((nt * (nt - 1)) / 2));
      current_statement__ = 6;
      if (jacobian__) {
        current_statement__ = 6;
        assign(C_R, nil_index_list(),
          stan::math::corr_matrix_constrain(C_R_in__, nt, lp__),
          "assigning variable C_R");
      } else {
        current_statement__ = 6;
        assign(C_R, nil_index_list(),
          stan::math::corr_matrix_constrain(C_R_in__, nt),
          "assigning variable C_R");
      }
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> A_raw;
      A_raw = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(Q, Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt));
      stan::math::fill(A_raw, DUMMY_VAR__);
      
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
        current_statement__ = 7;
        assign(A_raw, cons_list(index_uni(sym1__), nil_index_list()),
          in__.matrix(nt, nt), "assigning variable A_raw");}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> B_raw;
      B_raw = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(P, Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt));
      stan::math::fill(B_raw, DUMMY_VAR__);
      
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 8;
        assign(B_raw, cons_list(index_uni(sym1__), nil_index_list()),
          in__.matrix(nt, nt), "assigning variable B_raw");}
      Eigen::Matrix<local_scalar_t__, -1, -1> H1_init;
      H1_init = Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt);
      stan::math::fill(H1_init, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> H1_init_in__;
      H1_init_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>((nt +
                                                              ((nt *
                                                                 (nt - 1)) /
                                                                2)));
      stan::math::fill(H1_init_in__, DUMMY_VAR__);
      
      current_statement__ = 9;
      H1_init_in__ = in__.vector((nt + ((nt * (nt - 1)) / 2)));
      current_statement__ = 9;
      if (jacobian__) {
        current_statement__ = 9;
        assign(H1_init, nil_index_list(),
          stan::math::cov_matrix_constrain(H1_init_in__, nt, lp__),
          "assigning variable H1_init");
      } else {
        current_statement__ = 9;
        assign(H1_init, nil_index_list(),
          stan::math::cov_matrix_constrain(H1_init_in__, nt),
          "assigning variable H1_init");
      }
      local_scalar_t__ nu;
      nu = DUMMY_VAR__;
      
      current_statement__ = 10;
      nu = in__.scalar();
      current_statement__ = 10;
      if (jacobian__) {
        current_statement__ = 10;
        nu = stan::math::lb_constrain(nu, 2, lp__);
      } else {
        current_statement__ = 10;
        nu = stan::math::lb_constrain(nu, 2);
      }
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> H;
      H = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(T, Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt));
      stan::math::fill(H, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> rr;
      rr = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(rr_1dim__, Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt));
      stan::math::fill(rr, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> mu;
      mu = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(T, Eigen::Matrix<local_scalar_t__, -1, 1>(nt));
      stan::math::fill(mu, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> A_part;
      A_part = Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt);
      stan::math::fill(A_part, DUMMY_VAR__);
      
      current_statement__ = 14;
      assign(A_part, nil_index_list(), diag_matrix(rep_vector(0.0, nt)),
        "assigning variable A_part");
      Eigen::Matrix<local_scalar_t__, -1, -1> B_part;
      B_part = Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt);
      stan::math::fill(B_part, DUMMY_VAR__);
      
      current_statement__ = 15;
      assign(B_part, nil_index_list(), diag_matrix(rep_vector(0.0, nt)),
        "assigning variable B_part");
      Eigen::Matrix<local_scalar_t__, -1, -1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, -1>(beta_1dim__, nt);
      stan::math::fill(beta, DUMMY_VAR__);
      
      current_statement__ = 16;
      assign(beta, nil_index_list(), append_row(beta0, diag_matrix(beta1)),
        "assigning variable beta");
      Eigen::Matrix<local_scalar_t__, 1, -1> C_sd;
      C_sd = Eigen::Matrix<local_scalar_t__, 1, -1>(nt);
      stan::math::fill(C_sd, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> Cnst;
      Cnst = Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt);
      stan::math::fill(Cnst, DUMMY_VAR__);
      
      current_statement__ = 19;
      assign(mu,
        cons_list(index_uni(1), cons_list(index_omni(), nil_index_list())),
        phi0, "assigning variable mu");
      current_statement__ = 20;
      assign(H,
        cons_list(index_uni(1), cons_list(index_omni(), nil_index_list())),
        H1_init, "assigning variable H");
      current_statement__ = 50;
      for (int t = 2; t <= T; ++t) {
        current_statement__ = 29;
        if (logical_eq(meanstructure, 0)) {
          current_statement__ = 27;
          assign(mu,
            cons_list(index_uni(t),
              cons_list(index_omni(), nil_index_list())), phi0,
            "assigning variable mu");
        } else {
          current_statement__ = 26;
          if (logical_eq(meanstructure, 1)) {
            current_statement__ = 24;
            assign(mu,
              cons_list(index_uni(t),
                cons_list(index_omni(), nil_index_list())),
              add(
                add(phi0,
                  multiply(phi,
                    rvalue(rts,
                      cons_list(index_uni((t - 1)),
                        cons_list(index_omni(), nil_index_list())), "rts"))),
                multiply(theta,
                  subtract(
                    rvalue(rts,
                      cons_list(index_uni((t - 1)),
                        cons_list(index_omni(), nil_index_list())), "rts"),
                    stan::model::deep_copy(
                      rvalue(mu,
                        cons_list(index_uni((t - 1)),
                          cons_list(index_omni(), nil_index_list())), "mu"))))),
              "assigning variable mu");
          } else {
            current_statement__ = 23;
            if (logical_eq(meanstructure, 2)) {
              current_statement__ = 21;
              assign(mu,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())),
                add(phi0,
                  multiply(phi,
                    rvalue(rts,
                      cons_list(index_uni((t - 1)),
                        cons_list(index_omni(), nil_index_list())), "rts"))),
                "assigning variable mu");
            } 
          }
        }
        current_statement__ = 30;
        assign(A_part, nil_index_list(), diag_matrix(rep_vector(0.0, nt)),
          "assigning variable A_part");
        current_statement__ = 31;
        assign(B_part, nil_index_list(), diag_matrix(rep_vector(0.0, nt)),
          "assigning variable B_part");
        current_statement__ = 35;
        for (int q = 1; q <= std::min((t - 1), Q); ++q) {
          current_statement__ = 32;
          assign(rr,
            cons_list(index_uni((t - q)),
              cons_list(index_omni(), nil_index_list())),
            multiply(
              subtract(
                rvalue(rts,
                  cons_list(index_uni((t - q)),
                    cons_list(index_omni(), nil_index_list())), "rts"),
                rvalue(mu,
                  cons_list(index_uni((t - q)),
                    cons_list(index_omni(), nil_index_list())), "mu")),
              transpose(
                subtract(
                  rvalue(rts,
                    cons_list(index_uni((t - q)),
                      cons_list(index_omni(), nil_index_list())), "rts"),
                  rvalue(mu,
                    cons_list(index_uni((t - q)),
                      cons_list(index_omni(), nil_index_list())), "mu")))),
            "assigning variable rr");
          current_statement__ = 33;
          assign(A_part, nil_index_list(),
            add(stan::model::deep_copy(A_part),
              multiply(
                multiply(transpose(A_raw[(q - 1)]),
                  rvalue(rr,
                    cons_list(index_uni((t - q)),
                      cons_list(index_omni(), nil_index_list())), "rr")),
                A_raw[(q - 1)])), "assigning variable A_part");}
        current_statement__ = 38;
        for (int p = 1; p <= std::min((t - 1), P); ++p) {
          current_statement__ = 36;
          assign(B_part, nil_index_list(),
            add(stan::model::deep_copy(B_part),
              multiply(
                multiply(transpose(B_raw[(p - 1)]),
                  rvalue(H,
                    cons_list(index_uni((t - p)),
                      cons_list(index_omni(), nil_index_list())), "H")),
                B_raw[(p - 1)])), "assigning variable B_part");}
        current_statement__ = 48;
        if (logical_eq(xC_marker, 0)) {
          current_statement__ = 44;
          assign(C_sd, nil_index_list(), stan::math::exp(beta0),
            "assigning variable C_sd");
          current_statement__ = 45;
          assign(Cnst, nil_index_list(), quad_form_diag(C_R, C_sd),
            "assigning variable Cnst");
          current_statement__ = 46;
          assign(H,
            cons_list(index_uni(t),
              cons_list(index_omni(), nil_index_list())),
            add(add(Cnst, A_part), B_part), "assigning variable H");
        } else {
          current_statement__ = 43;
          if (logical_gte(xC_marker, 1)) {
            current_statement__ = 39;
            assign(C_sd, nil_index_list(),
              stan::math::exp(
                multiply(append_col(1.0, transpose(xC[(t - 1)])), beta)),
              "assigning variable C_sd");
            current_statement__ = 40;
            assign(Cnst, nil_index_list(), quad_form_diag(C_R, C_sd),
              "assigning variable Cnst");
            current_statement__ = 41;
            assign(H,
              cons_list(index_uni(t),
                cons_list(index_omni(), nil_index_list())),
              add(add(Cnst, A_part), B_part), "assigning variable H");
          } 
        }}
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 11;
        current_statement__ = 11;
        check_cov_matrix(function__, "H[sym1__]", H[(sym1__ - 1)]);}
      current_statement__ = 18;
      current_statement__ = 18;
      check_cov_matrix(function__, "Cnst", Cnst);
      {
        current_statement__ = 84;
        lp_accum__.add(normal_lpdf<propto__>(nu, nt, 50));
        current_statement__ = 85;
        lp_accum__.add(
          wishart_lpdf<propto__>(H1_init, (nt + 1.0),
            diag_matrix(rep_vector(1.0, nt))));
        current_statement__ = 86;
        lp_accum__.add(std_normal_lpdf<propto__>(to_vector(theta)));
        current_statement__ = 87;
        lp_accum__.add(std_normal_lpdf<propto__>(to_vector(phi)));
        current_statement__ = 88;
        lp_accum__.add(
          multi_normal_lpdf<propto__>(phi0, rts_m, diag_matrix(rts_sd)));
        current_statement__ = 89;
        lp_accum__.add(std_normal_lpdf<propto__>(to_vector(beta0)));
        current_statement__ = 90;
        lp_accum__.add(std_normal_lpdf<propto__>(to_vector(beta1)));
        current_statement__ = 91;
        lp_accum__.add(lkj_corr_lpdf<propto__>(C_R, 1));
        current_statement__ = 94;
        for (int q = 1; q <= Q; ++q) {
          current_statement__ = 92;
          lp_accum__.add(std_normal_lpdf<propto__>(to_vector(A_raw[(q - 1)])));
        }
        current_statement__ = 97;
        for (int p = 1; p <= P; ++p) {
          current_statement__ = 95;
          lp_accum__.add(std_normal_lpdf<propto__>(to_vector(B_raw[(p - 1)])));
        }
        current_statement__ = 107;
        if (logical_eq(distribution, 0)) {
          current_statement__ = 105;
          for (int t = 1; t <= T; ++t) {
            current_statement__ = 103;
            lp_accum__.add(
              multi_normal_lpdf<false>(
                rvalue(rts,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "rts"),
                rvalue(mu,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "mu"),
                rvalue(H,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "H")));}
        } else {
          current_statement__ = 102;
          if (logical_eq(distribution, 1)) {
            current_statement__ = 100;
            for (int t = 1; t <= T; ++t) {
              current_statement__ = 98;
              lp_accum__.add(
                multi_student_t_lpdf<false>(
                  rvalue(rts,
                    cons_list(index_uni(t),
                      cons_list(index_omni(), nil_index_list())), "rts"), nu,
                  rvalue(mu,
                    cons_list(index_uni(t),
                      cons_list(index_omni(), nil_index_list())), "mu"),
                  rvalue(H,
                    cons_list(index_uni(t),
                      cons_list(index_omni(), nil_index_list())), "H")));}
          } 
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_BEKKMGARCH_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> phi0;
      phi0 = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(phi0, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      phi0 = in__.vector(nt);
      Eigen::Matrix<double, -1, -1> phi;
      phi = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(phi, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      phi = in__.matrix(nt, nt);
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 2;
          assign(phi,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_constrain(
              rvalue(phi,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym2__), nil_index_list())), "phi"),
              -1, 1), "assigning variable phi");}}
      Eigen::Matrix<double, -1, -1> theta;
      theta = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(theta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      theta = in__.matrix(nt, nt);
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 3;
          assign(theta,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_constrain(
              rvalue(theta,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym2__), nil_index_list())), "theta"),
              -1, 1), "assigning variable theta");}}
      Eigen::Matrix<double, 1, -1> beta0;
      beta0 = Eigen::Matrix<double, 1, -1>(nt);
      stan::math::fill(beta0, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      beta0 = in__.row_vector(nt);
      Eigen::Matrix<double, -1, 1> beta1;
      beta1 = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(beta1, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      beta1 = in__.vector(nt);
      Eigen::Matrix<double, -1, -1> C_R;
      C_R = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(C_R, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<local_scalar_t__, -1, 1> C_R_in__;
      C_R_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>(((nt * (nt - 1)) / 2));
      stan::math::fill(C_R_in__, DUMMY_VAR__);
      
      current_statement__ = 6;
      C_R_in__ = in__.vector(((nt * (nt - 1)) / 2));
      current_statement__ = 6;
      assign(C_R, nil_index_list(),
        stan::math::corr_matrix_constrain(C_R_in__, nt),
        "assigning variable C_R");
      std::vector<Eigen::Matrix<double, -1, -1>> A_raw;
      A_raw = std::vector<Eigen::Matrix<double, -1, -1>>(Q, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(A_raw, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
        current_statement__ = 7;
        assign(A_raw, cons_list(index_uni(sym1__), nil_index_list()),
          in__.matrix(nt, nt), "assigning variable A_raw");}
      std::vector<Eigen::Matrix<double, -1, -1>> B_raw;
      B_raw = std::vector<Eigen::Matrix<double, -1, -1>>(P, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(B_raw, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 8;
        assign(B_raw, cons_list(index_uni(sym1__), nil_index_list()),
          in__.matrix(nt, nt), "assigning variable B_raw");}
      Eigen::Matrix<double, -1, -1> H1_init;
      H1_init = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(H1_init, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<local_scalar_t__, -1, 1> H1_init_in__;
      H1_init_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>((nt +
                                                              ((nt *
                                                                 (nt - 1)) /
                                                                2)));
      stan::math::fill(H1_init_in__, DUMMY_VAR__);
      
      current_statement__ = 9;
      H1_init_in__ = in__.vector((nt + ((nt * (nt - 1)) / 2)));
      current_statement__ = 9;
      assign(H1_init, nil_index_list(),
        stan::math::cov_matrix_constrain(H1_init_in__, nt),
        "assigning variable H1_init");
      double nu;
      nu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 10;
      nu = in__.scalar();
      current_statement__ = 10;
      nu = stan::math::lb_constrain(nu, 2);
      std::vector<Eigen::Matrix<double, -1, -1>> H;
      H = std::vector<Eigen::Matrix<double, -1, -1>>(T, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(H, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, -1>> rr;
      rr = std::vector<Eigen::Matrix<double, -1, -1>>(rr_1dim__, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(rr, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> mu;
      mu = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(mu, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> A_part;
      A_part = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(A_part, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> B_part;
      B_part = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(B_part, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> beta;
      beta = Eigen::Matrix<double, -1, -1>(beta_1dim__, nt);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, 1, -1> C_sd;
      C_sd = Eigen::Matrix<double, 1, -1>(nt);
      stan::math::fill(C_sd, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> Cnst;
      Cnst = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(Cnst, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(phi0[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(phi,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "phi"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(theta,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "theta"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(beta0[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(beta1[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(C_R,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "C_R"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= Q; ++sym3__) {
            vars__.emplace_back(
              rvalue(A_raw,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                "A_raw"));}}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= P; ++sym3__) {
            vars__.emplace_back(
              rvalue(B_raw,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                "B_raw"));}}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(H1_init,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "H1_init"));
        }}
      vars__.emplace_back(nu);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 14;
      assign(A_part, nil_index_list(), diag_matrix(rep_vector(0.0, nt)),
        "assigning variable A_part");
      current_statement__ = 15;
      assign(B_part, nil_index_list(), diag_matrix(rep_vector(0.0, nt)),
        "assigning variable B_part");
      current_statement__ = 16;
      assign(beta, nil_index_list(), append_row(beta0, diag_matrix(beta1)),
        "assigning variable beta");
      current_statement__ = 19;
      assign(mu,
        cons_list(index_uni(1), cons_list(index_omni(), nil_index_list())),
        phi0, "assigning variable mu");
      current_statement__ = 20;
      assign(H,
        cons_list(index_uni(1), cons_list(index_omni(), nil_index_list())),
        H1_init, "assigning variable H");
      current_statement__ = 50;
      for (int t = 2; t <= T; ++t) {
        current_statement__ = 29;
        if (logical_eq(meanstructure, 0)) {
          current_statement__ = 27;
          assign(mu,
            cons_list(index_uni(t),
              cons_list(index_omni(), nil_index_list())), phi0,
            "assigning variable mu");
        } else {
          current_statement__ = 26;
          if (logical_eq(meanstructure, 1)) {
            current_statement__ = 24;
            assign(mu,
              cons_list(index_uni(t),
                cons_list(index_omni(), nil_index_list())),
              add(
                add(phi0,
                  multiply(phi,
                    rvalue(rts,
                      cons_list(index_uni((t - 1)),
                        cons_list(index_omni(), nil_index_list())), "rts"))),
                multiply(theta,
                  subtract(
                    rvalue(rts,
                      cons_list(index_uni((t - 1)),
                        cons_list(index_omni(), nil_index_list())), "rts"),
                    stan::model::deep_copy(
                      rvalue(mu,
                        cons_list(index_uni((t - 1)),
                          cons_list(index_omni(), nil_index_list())), "mu"))))),
              "assigning variable mu");
          } else {
            current_statement__ = 23;
            if (logical_eq(meanstructure, 2)) {
              current_statement__ = 21;
              assign(mu,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())),
                add(phi0,
                  multiply(phi,
                    rvalue(rts,
                      cons_list(index_uni((t - 1)),
                        cons_list(index_omni(), nil_index_list())), "rts"))),
                "assigning variable mu");
            } 
          }
        }
        current_statement__ = 30;
        assign(A_part, nil_index_list(), diag_matrix(rep_vector(0.0, nt)),
          "assigning variable A_part");
        current_statement__ = 31;
        assign(B_part, nil_index_list(), diag_matrix(rep_vector(0.0, nt)),
          "assigning variable B_part");
        current_statement__ = 35;
        for (int q = 1; q <= std::min((t - 1), Q); ++q) {
          current_statement__ = 32;
          assign(rr,
            cons_list(index_uni((t - q)),
              cons_list(index_omni(), nil_index_list())),
            multiply(
              subtract(
                rvalue(rts,
                  cons_list(index_uni((t - q)),
                    cons_list(index_omni(), nil_index_list())), "rts"),
                rvalue(mu,
                  cons_list(index_uni((t - q)),
                    cons_list(index_omni(), nil_index_list())), "mu")),
              transpose(
                subtract(
                  rvalue(rts,
                    cons_list(index_uni((t - q)),
                      cons_list(index_omni(), nil_index_list())), "rts"),
                  rvalue(mu,
                    cons_list(index_uni((t - q)),
                      cons_list(index_omni(), nil_index_list())), "mu")))),
            "assigning variable rr");
          current_statement__ = 33;
          assign(A_part, nil_index_list(),
            add(stan::model::deep_copy(A_part),
              multiply(
                multiply(transpose(A_raw[(q - 1)]),
                  rvalue(rr,
                    cons_list(index_uni((t - q)),
                      cons_list(index_omni(), nil_index_list())), "rr")),
                A_raw[(q - 1)])), "assigning variable A_part");}
        current_statement__ = 38;
        for (int p = 1; p <= std::min((t - 1), P); ++p) {
          current_statement__ = 36;
          assign(B_part, nil_index_list(),
            add(stan::model::deep_copy(B_part),
              multiply(
                multiply(transpose(B_raw[(p - 1)]),
                  rvalue(H,
                    cons_list(index_uni((t - p)),
                      cons_list(index_omni(), nil_index_list())), "H")),
                B_raw[(p - 1)])), "assigning variable B_part");}
        current_statement__ = 48;
        if (logical_eq(xC_marker, 0)) {
          current_statement__ = 44;
          assign(C_sd, nil_index_list(), stan::math::exp(beta0),
            "assigning variable C_sd");
          current_statement__ = 45;
          assign(Cnst, nil_index_list(), quad_form_diag(C_R, C_sd),
            "assigning variable Cnst");
          current_statement__ = 46;
          assign(H,
            cons_list(index_uni(t),
              cons_list(index_omni(), nil_index_list())),
            add(add(Cnst, A_part), B_part), "assigning variable H");
        } else {
          current_statement__ = 43;
          if (logical_gte(xC_marker, 1)) {
            current_statement__ = 39;
            assign(C_sd, nil_index_list(),
              stan::math::exp(
                multiply(append_col(1.0, transpose(xC[(t - 1)])), beta)),
              "assigning variable C_sd");
            current_statement__ = 40;
            assign(Cnst, nil_index_list(), quad_form_diag(C_R, C_sd),
              "assigning variable Cnst");
            current_statement__ = 41;
            assign(H,
              cons_list(index_uni(t),
                cons_list(index_omni(), nil_index_list())),
              add(add(Cnst, A_part), B_part), "assigning variable H");
          } 
        }}
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 11;
        current_statement__ = 11;
        check_cov_matrix(function__, "H[sym1__]", H[(sym1__ - 1)]);}
      current_statement__ = 18;
      current_statement__ = 18;
      check_cov_matrix(function__, "Cnst", Cnst);
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
              vars__.emplace_back(
                rvalue(H,
                  cons_list(index_uni(sym3__),
                    cons_list(index_uni(sym2__),
                      cons_list(index_uni(sym1__), nil_index_list()))), "H"));
            }}}
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            for (int sym3__ = 1; sym3__ <= rr_1dim__; ++sym3__) {
              vars__.emplace_back(
                rvalue(rr,
                  cons_list(index_uni(sym3__),
                    cons_list(index_uni(sym2__),
                      cons_list(index_uni(sym1__), nil_index_list()))), "rr"));
            }}}
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            vars__.emplace_back(mu[(sym2__ - 1)][(sym1__ - 1)]);}}
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            vars__.emplace_back(
              rvalue(A_part,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "A_part"));
          }}
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            vars__.emplace_back(
              rvalue(B_part,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "B_part"));
          }}
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= beta_1dim__; ++sym2__) {
            vars__.emplace_back(
              rvalue(beta,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "beta"));}
        }
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          vars__.emplace_back(C_sd[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            vars__.emplace_back(
              rvalue(Cnst,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "Cnst"));}
        }
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      std::vector<Eigen::Matrix<double, -1, -1>> A;
      A = std::vector<Eigen::Matrix<double, -1, -1>>(Q, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(A, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 51;
      assign(A, nil_index_list(), A_raw, "assigning variable A");
      std::vector<Eigen::Matrix<double, -1, -1>> B;
      B = std::vector<Eigen::Matrix<double, -1, -1>>(P, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(B, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 52;
      assign(B, nil_index_list(), B_raw, "assigning variable B");
      Eigen::Matrix<double, -1, -1> rts_out;
      rts_out = Eigen::Matrix<double, -1, -1>(nt, T);
      stan::math::fill(rts_out, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<double> log_lik;
      log_lik = std::vector<double>(T, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> corC;
      corC = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(corC, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, -1>> corH;
      corH = std::vector<Eigen::Matrix<double, -1, -1>>(T, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(corH, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, 1, -1> C_var;
      C_var = Eigen::Matrix<double, 1, -1>(nt);
      stan::math::fill(C_var, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 62;
      for (int q = 1; q <= Q; ++q) {
        current_statement__ = 60;
        if (logical_lt(
              rvalue(A,
                cons_list(index_uni(q),
                  cons_list(index_uni(1),
                    cons_list(index_uni(1), nil_index_list()))), "A"), 0)) {
          current_statement__ = 58;
          assign(A, cons_list(index_uni(q), nil_index_list()),
            minus(stan::model::deep_copy(A[(q - 1)])), "assigning variable A");
        } }
      current_statement__ = 67;
      for (int p = 1; p <= P; ++p) {
        current_statement__ = 65;
        if (logical_lt(
              rvalue(B,
                cons_list(index_uni(p),
                  cons_list(index_uni(1),
                    cons_list(index_uni(1), nil_index_list()))), "B"), 0)) {
          current_statement__ = 63;
          assign(B, cons_list(index_uni(p), nil_index_list()),
            minus(stan::model::deep_copy(B[(p - 1)])), "assigning variable B");
        } }
      current_statement__ = 68;
      assign(corC, nil_index_list(), C_R, "assigning variable corC");
      current_statement__ = 69;
      assign(C_var, nil_index_list(), stan::math::exp(multiply(2, beta0)),
        "assigning variable C_var");
      current_statement__ = 83;
      if (logical_eq(distribution, 0)) {
        current_statement__ = 81;
        for (int t = 1; t <= T; ++t) {
          current_statement__ = 77;
          assign(rts_out,
            cons_list(index_omni(),
              cons_list(index_uni(t), nil_index_list())),
            multi_normal_rng(
              rvalue(mu,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())), "mu"),
              rvalue(H,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())), "H"),
              base_rng__), "assigning variable rts_out");
          current_statement__ = 78;
          assign(corH,
            cons_list(index_uni(t),
              cons_list(index_omni(), nil_index_list())),
            cov2cor(
              rvalue(H,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())), "H"), pstream__),
            "assigning variable corH");
          current_statement__ = 79;
          assign(log_lik, cons_list(index_uni(t), nil_index_list()),
            multi_normal_lpdf<false>(
              rvalue(rts,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())), "rts"),
              rvalue(mu,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())), "mu"),
              rvalue(H,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())), "H")),
            "assigning variable log_lik");}
      } else {
        current_statement__ = 76;
        if (logical_eq(distribution, 1)) {
          current_statement__ = 74;
          for (int t = 1; t <= T; ++t) {
            current_statement__ = 70;
            assign(rts_out,
              cons_list(index_omni(),
                cons_list(index_uni(t), nil_index_list())),
              multi_student_t_rng(nu,
                rvalue(mu,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "mu"),
                rvalue(H,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "H"),
                base_rng__), "assigning variable rts_out");
            current_statement__ = 71;
            assign(corH,
              cons_list(index_uni(t),
                cons_list(index_omni(), nil_index_list())),
              cov2cor(
                rvalue(H,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "H"), pstream__),
              "assigning variable corH");
            current_statement__ = 72;
            assign(log_lik, cons_list(index_uni(t), nil_index_list()),
              multi_student_t_lpdf<false>(
                rvalue(rts,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "rts"), nu,
                rvalue(mu,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "mu"),
                rvalue(H,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "H")),
              "assigning variable log_lik");}
        } 
      }
      current_statement__ = 55;
      current_statement__ = 55;
      check_corr_matrix(function__, "corC", corC);
      current_statement__ = 56;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 56;
        current_statement__ = 56;
        check_corr_matrix(function__, "corH[sym1__]", corH[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= Q; ++sym3__) {
            vars__.emplace_back(
              rvalue(A,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))), "A"));}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= P; ++sym3__) {
            vars__.emplace_back(
              rvalue(B,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))), "B"));}
        }}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(rts_out,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "rts_out"));
        }}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        vars__.emplace_back(log_lik[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(corC,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "corC"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
            vars__.emplace_back(
              rvalue(corH,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))), "corH"));
          }}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(C_var[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> phi0;
      phi0 = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(phi0, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> phi0_flat__;
        current_statement__ = 1;
        assign(phi0_flat__, nil_index_list(), context__.vals_r("phi0"),
          "assigning variable phi0_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 1;
          assign(phi0, cons_list(index_uni(sym1__), nil_index_list()),
            phi0_flat__[(pos__ - 1)], "assigning variable phi0");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, -1> phi;
      phi = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(phi, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> phi_flat__;
        current_statement__ = 2;
        assign(phi_flat__, nil_index_list(), context__.vals_r("phi"),
          "assigning variable phi_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 2;
            assign(phi,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              phi_flat__[(pos__ - 1)], "assigning variable phi");
            current_statement__ = 2;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, -1> phi_free__;
      phi_free__ = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(phi_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 2;
          assign(phi_free__,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_free(
              rvalue(phi,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym2__), nil_index_list())), "phi"),
              -1, 1), "assigning variable phi_free__");}}
      Eigen::Matrix<double, -1, -1> theta;
      theta = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(theta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> theta_flat__;
        current_statement__ = 3;
        assign(theta_flat__, nil_index_list(), context__.vals_r("theta"),
          "assigning variable theta_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 3;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 3;
            assign(theta,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              theta_flat__[(pos__ - 1)], "assigning variable theta");
            current_statement__ = 3;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, -1> theta_free__;
      theta_free__ = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(theta_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 3;
          assign(theta_free__,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_free(
              rvalue(theta,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym2__), nil_index_list())), "theta"),
              -1, 1), "assigning variable theta_free__");}}
      Eigen::Matrix<double, 1, -1> beta0;
      beta0 = Eigen::Matrix<double, 1, -1>(nt);
      stan::math::fill(beta0, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta0_flat__;
        current_statement__ = 4;
        assign(beta0_flat__, nil_index_list(), context__.vals_r("beta0"),
          "assigning variable beta0_flat__");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 4;
          assign(beta0, cons_list(index_uni(sym1__), nil_index_list()),
            beta0_flat__[(pos__ - 1)], "assigning variable beta0");
          current_statement__ = 4;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> beta1;
      beta1 = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(beta1, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta1_flat__;
        current_statement__ = 5;
        assign(beta1_flat__, nil_index_list(), context__.vals_r("beta1"),
          "assigning variable beta1_flat__");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 5;
          assign(beta1, cons_list(index_uni(sym1__), nil_index_list()),
            beta1_flat__[(pos__ - 1)], "assigning variable beta1");
          current_statement__ = 5;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, -1> C_R;
      C_R = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(C_R, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> C_R_flat__;
        current_statement__ = 6;
        assign(C_R_flat__, nil_index_list(), context__.vals_r("C_R"),
          "assigning variable C_R_flat__");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 6;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 6;
            assign(C_R,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              C_R_flat__[(pos__ - 1)], "assigning variable C_R");
            current_statement__ = 6;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, 1> C_R_free__;
      C_R_free__ = Eigen::Matrix<double, -1, 1>(((nt * (nt - 1)) / 2));
      stan::math::fill(C_R_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      assign(C_R_free__, nil_index_list(), stan::math::corr_matrix_free(C_R),
        "assigning variable C_R_free__");
      std::vector<Eigen::Matrix<double, -1, -1>> A_raw;
      A_raw = std::vector<Eigen::Matrix<double, -1, -1>>(Q, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(A_raw, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> A_raw_flat__;
        current_statement__ = 7;
        assign(A_raw_flat__, nil_index_list(), context__.vals_r("A_raw"),
          "assigning variable A_raw_flat__");
        current_statement__ = 7;
        pos__ = 1;
        current_statement__ = 7;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 7;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 7;
            for (int sym3__ = 1; sym3__ <= Q; ++sym3__) {
              current_statement__ = 7;
              assign(A_raw,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                A_raw_flat__[(pos__ - 1)], "assigning variable A_raw");
              current_statement__ = 7;
              pos__ = (pos__ + 1);}}}
      }
      std::vector<Eigen::Matrix<double, -1, -1>> B_raw;
      B_raw = std::vector<Eigen::Matrix<double, -1, -1>>(P, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(B_raw, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> B_raw_flat__;
        current_statement__ = 8;
        assign(B_raw_flat__, nil_index_list(), context__.vals_r("B_raw"),
          "assigning variable B_raw_flat__");
        current_statement__ = 8;
        pos__ = 1;
        current_statement__ = 8;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 8;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 8;
            for (int sym3__ = 1; sym3__ <= P; ++sym3__) {
              current_statement__ = 8;
              assign(B_raw,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                B_raw_flat__[(pos__ - 1)], "assigning variable B_raw");
              current_statement__ = 8;
              pos__ = (pos__ + 1);}}}
      }
      Eigen::Matrix<double, -1, -1> H1_init;
      H1_init = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(H1_init, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> H1_init_flat__;
        current_statement__ = 9;
        assign(H1_init_flat__, nil_index_list(), context__.vals_r("H1_init"),
          "assigning variable H1_init_flat__");
        current_statement__ = 9;
        pos__ = 1;
        current_statement__ = 9;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 9;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 9;
            assign(H1_init,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              H1_init_flat__[(pos__ - 1)], "assigning variable H1_init");
            current_statement__ = 9;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, 1> H1_init_free__;
      H1_init_free__ = Eigen::Matrix<double, -1, 1>((nt +
                                                      ((nt * (nt - 1)) / 2)));
      stan::math::fill(H1_init_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 9;
      assign(H1_init_free__, nil_index_list(),
        stan::math::cov_matrix_free(H1_init),
        "assigning variable H1_init_free__");
      double nu;
      nu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 10;
      nu = context__.vals_r("nu")[(1 - 1)];
      double nu_free__;
      nu_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 10;
      nu_free__ = stan::math::lb_free(nu, 2);
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(phi0[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(phi_free__,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              "phi_free__"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(theta_free__,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              "theta_free__"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(beta0[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(beta1[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= ((nt * (nt - 1)) / 2); ++sym1__) {
        vars__.emplace_back(C_R_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= nt; ++sym3__) {
            vars__.emplace_back(
              rvalue(A_raw,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym3__),
                    cons_list(index_uni(sym2__), nil_index_list()))),
                "A_raw"));}}}
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= nt; ++sym3__) {
            vars__.emplace_back(
              rvalue(B_raw,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym3__),
                    cons_list(index_uni(sym2__), nil_index_list()))),
                "B_raw"));}}}
      for (int sym1__ = 1; sym1__ <= (nt + ((nt * (nt - 1)) / 2)); ++sym1__) {
        vars__.emplace_back(H1_init_free__[(sym1__ - 1)]);}
      vars__.emplace_back(nu_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("phi0");
    names__.emplace_back("phi");
    names__.emplace_back("theta");
    names__.emplace_back("beta0");
    names__.emplace_back("beta1");
    names__.emplace_back("C_R");
    names__.emplace_back("A_raw");
    names__.emplace_back("B_raw");
    names__.emplace_back("H1_init");
    names__.emplace_back("nu");
    names__.emplace_back("H");
    names__.emplace_back("rr");
    names__.emplace_back("mu");
    names__.emplace_back("A_part");
    names__.emplace_back("B_part");
    names__.emplace_back("beta");
    names__.emplace_back("C_sd");
    names__.emplace_back("Cnst");
    names__.emplace_back("A");
    names__.emplace_back("B");
    names__.emplace_back("rts_out");
    names__.emplace_back("log_lik");
    names__.emplace_back("corC");
    names__.emplace_back("corH");
    names__.emplace_back("C_var");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(Q),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(P),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(rr_1dim__),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(beta_1dim__)
                                             , static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(Q),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(P),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(T)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "phi0" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "phi" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "theta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta0" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta1" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "C_R" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= Q; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "A_raw" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= P; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "B_raw" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "H1_init" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    param_names__.emplace_back(std::string() + "nu");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "H" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= rr_1dim__; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "rr" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "A_part" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "B_part" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= beta_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "C_sd" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "Cnst" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= Q; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "A" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= P; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "B" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rts_out" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "corC" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "corH" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "C_var" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "phi0" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "phi" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "theta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta0" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta1" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= ((nt * (nt - 1)) / 2); ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "C_R" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= Q; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "A_raw" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= P; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "B_raw" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= (nt + ((nt * (nt - 1)) / 2)); ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "H1_init" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "nu");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= (nt + ((nt * (nt - 1)) / 2)); ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "H" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= rr_1dim__; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "rr" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "A_part" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "B_part" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= beta_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "C_sd" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= (nt + ((nt * (nt - 1)) / 2)); ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "Cnst" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= Q; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "A" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= P; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "B" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rts_out" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= ((nt * (nt - 1)) / 2); ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "corC" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= ((nt * (nt - 1)) / 2); ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "corH" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "C_var" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"phi0\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"beta0\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"beta1\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"C_R\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"A_raw\",\"type\":{\"name\":\"array\",\"length\":" << Q << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"B_raw\",\"type\":{\"name\":\"array\",\"length\":" << P << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"H1_init\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"H\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"transformed_parameters\"},{\"name\":\"rr\",\"type\":{\"name\":\"array\",\"length\":" << rr_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"transformed_parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"transformed_parameters\"},{\"name\":\"A_part\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"transformed_parameters\"},{\"name\":\"B_part\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"transformed_parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"matrix\",\"rows\":" << beta_1dim__ << ",\"cols\":" << nt << "},\"block\":\"transformed_parameters\"},{\"name\":\"C_sd\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"transformed_parameters\"},{\"name\":\"Cnst\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"transformed_parameters\"},{\"name\":\"A\",\"type\":{\"name\":\"array\",\"length\":" << Q << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"B\",\"type\":{\"name\":\"array\",\"length\":" << P << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"rts_out\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << T << "},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"corC\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"generated_quantities\"},{\"name\":\"corH\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"C_var\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"phi0\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"beta0\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"beta1\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"C_R\",\"type\":{\"name\":\"vector\",\"length\":" << ((nt * (nt - 1)) / 2) << "},\"block\":\"parameters\"},{\"name\":\"A_raw\",\"type\":{\"name\":\"array\",\"length\":" << Q << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"B_raw\",\"type\":{\"name\":\"array\",\"length\":" << P << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"H1_init\",\"type\":{\"name\":\"vector\",\"length\":" << (nt + ((nt * (nt - 1)) / 2)) << "},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"H\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << (nt + ((nt * (nt - 1)) / 2)) << "}},\"block\":\"transformed_parameters\"},{\"name\":\"rr\",\"type\":{\"name\":\"array\",\"length\":" << rr_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"transformed_parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"transformed_parameters\"},{\"name\":\"A_part\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"transformed_parameters\"},{\"name\":\"B_part\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"transformed_parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"matrix\",\"rows\":" << beta_1dim__ << ",\"cols\":" << nt << "},\"block\":\"transformed_parameters\"},{\"name\":\"C_sd\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"transformed_parameters\"},{\"name\":\"Cnst\",\"type\":{\"name\":\"vector\",\"length\":" << (nt + ((nt * (nt - 1)) / 2)) << "},\"block\":\"transformed_parameters\"},{\"name\":\"A\",\"type\":{\"name\":\"array\",\"length\":" << Q << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"B\",\"type\":{\"name\":\"array\",\"length\":" << P << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"rts_out\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << T << "},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"corC\",\"type\":{\"name\":\"vector\",\"length\":" << ((nt * (nt - 1)) / 2) << "},\"block\":\"generated_quantities\"},{\"name\":\"corH\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << ((nt * (nt - 1)) / 2) << "}},\"block\":\"generated_quantities\"},{\"name\":\"C_var\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_BEKKMGARCH_namespace::model_BEKKMGARCH;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_BEKKMGARCH_namespace::profiles__;
}
#endif
#endif
