% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.ordered.one.var.R
\name{check.ordered.one.var}
\alias{check.ordered.one.var}
\title{Verify if one specific variable of a data set is an ordered factor}
\usage{
check.ordered.one.var(data.to.work, var.name)
}
\arguments{
\item{data.to.work}{is a data set containing the variables to be checked.}

\item{var.name}{is the name of variable to be checked.}
}
\value{
TRUE or FALSE
}
\description{
Receives a data set, the name of a specific variable and verify if it is an ordered factor or not. If 'yes' then the function return TRUE.
}
\examples{
# Clean environment
closeAllConnections()
rm(list=ls())
# Set enviroment
# setwd("to your working directory")
# Load packages
library(bnpa)
# Use working data sets from package
data(dataQualiN)
head(dataQualiN)
# Transform variable A into ordered factor
dataQualiN$A <- ordered(dataQualiN$A)
# Check variable A and return TRUE
var.name <- "A"
check.ordered.one.var(dataQualiN, var.name)
# Check variable B and return FALSE
var.name <- "B"
check.ordered.one.var(dataQualiN, var.name)
}
\references{
HAYES, A F; PREACHER, K J. Statistical mediation analysis with a multicategorical independent variable. British Journal of Mathematical and Statistical Psychology, v. 67, n. 3, p. 451-470, 2014.
}
\author{
Elias Carvalho
}
