% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/category-helpers.R
\name{boilerplate_methods}
\alias{boilerplate_methods}
\title{Access Methods from Unified Database}
\usage{
boilerplate_methods(unified_db, name = NULL)
}
\arguments{
\item{unified_db}{List. The unified boilerplate database}

\item{name}{Character. Optional specific method to retrieve using dot notation}
}
\value{
List or character. The requested methods database or specific method
}
\description{
This function extracts and returns the methods portion of a unified database,
optionally retrieving a specific method by name.
}
\examples{
# Create a temporary directory and initialise database
temp_dir <- tempdir()
data_path <- file.path(temp_dir, "boilerplate_methods_example", "data")

# Initialise with default methods content
boilerplate_init(
  categories = "methods",
  data_path = data_path,
  create_dirs = TRUE,
  create_empty = FALSE,
  confirm = FALSE,
  quiet = TRUE
)

# Import all databases
unified_db <- boilerplate_import(data_path = data_path, quiet = TRUE)

# Get all methods
methods_db <- boilerplate_methods(unified_db)
names(methods_db)

# Get a specific method using dot notation (if it exists)
if ("statistical" \%in\% names(methods_db) &&
    "longitudinal" \%in\% names(methods_db$statistical) &&
    "lmtp" \%in\% names(methods_db$statistical$longitudinal)) {
  lmtp_method <- boilerplate_methods(unified_db, "statistical.longitudinal.lmtp")
}

# Clean up
unlink(file.path(temp_dir, "boilerplate_methods_example"), recursive = TRUE)

}
