% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_variables.R
\name{get_variables}
\alias{get_variables}
\title{Get Available Variables}
\usage{
get_variables(theme, geography)
}
\arguments{
\item{theme}{theme as character string}

\item{geography}{geography as character string}
}
\value{
a \code{data.frame} with columns \code{KurznamePlus} (variable name), \code{Bereich} (theme identifier), 
\code{Gruppe} (variable identifier), \code{BU}, \code{EU}, \code{Zeitreihe} (all three unknown).
}
\description{
\code{get_variables} retrieves a data frame with available variables
}
\details{
To get a list of available geographies use \code{\link{get_geographies}}. To 
get a list of available themes use \code{\link{get_themes}}.
}
\examples{

# The SSL vertification seems to fail for some Linux systems. 
# This is likely because of a SSL certificate issue on the INKAR server. 
# Disabling SSL verification comes with risks: 
# https://curl.se/libcurl/c/CURLOPT_SSL_VERIFYPEER.html
httr::set_config(httr::config(ssl_verifypeer = 0L))

# Retrieves list of available variables in the  
# theme "unemployment" for districts 
get_variables(theme="011", geography="KRE")

# Reset configuration  
httr::reset_config()



}
\seealso{
\code{\link{get_geographies}} \code{\link{get_themes}}
}
