% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/YXadaptplsR.R
\name{coefs.plsR.adapt.ncomp}
\alias{coefs.plsR.adapt.ncomp}
\title{Bootstrap (Y,X) for the coefficients with number of components updated 
for each resampling.}
\usage{
coefs.plsR.adapt.ncomp(
  dataset,
  i,
  R = 1000,
  ncpus = 1,
  parallel = "no",
  verbose = FALSE
)
}
\arguments{
\item{dataset}{Dataset to use.}

\item{i}{Vector of resampling.}

\item{R}{Number of resamplings to find the number of components.}

\item{ncpus}{integer: number of processes to be used in parallel operation: 
typically one would chose this to the number of available CPUs.}

\item{parallel}{The type of parallel operation to be used (if any). 
If missing, the default is taken from the option "boot.parallel" 
(and if that is not set, "no").}

\item{verbose}{Suppress information messages.}
}
\value{
Numeric vector: first value is the number of components, the 
remaining values are the coefficients the variables computed for that number 
of components.
}
\description{
Bootstrap (Y,X) for the coefficients with number of components updated 
for each resampling.
}
\examples{
set.seed(314)
ncol=5
xran=matrix(rnorm(30*ncol),30,ncol)
coefs.plsR.adapt.ncomp(xran,sample(1:30))
\donttest{
coefs.plsR.adapt.ncomp(xran,sample(1:30),ncpus=2,parallel="multicore")
}
}
\references{
A new bootstrap-based stopping criterion in PLS component construction,
J. Magnanensi, M. Maumy-Bertrand, N. Meyer and F. Bertrand (2016), in The Multiple Facets of Partial Least Squares and Related Methods, 
\doi{10.1007/978-3-319-40643-5_18}\cr

A new universal resample-stable bootstrap-based stopping criterion for PLS component construction,
J. Magnanensi, F. Bertrand, M. Maumy-Bertrand and N. Meyer, (2017), Statistics and Computing, 27, 757–774. 
\doi{10.1007/s11222-016-9651-4}\cr

New developments in Sparse PLS regression, J. Magnanensi, M. Maumy-Bertrand, 
N. Meyer and F. Bertrand, (2021), Frontiers in Applied Mathematics and Statistics, 
\doi{10.3389/fams.2021.693126}\cr.
}
\author{
Jérémy Magnanensi, Frédéric Bertrand\cr
\email{frederic.bertrand@lecnam.net}\cr
\url{https://fbertran.github.io/homepage/}
}
