% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MacroTS.R
\docType{data}
\name{MacroTS}
\alias{MacroTS}
\title{Macroeconomic Time Series}
\format{
A time series object containing 20 macroeconomic seasonally adjusted time series, quarterly observed from 1992-2019 for Belgium (BE), Germany (DE), France (FR), the Netherlands (NL) and the United Kingdom (UK).

\describe{
\item{\verb{GDP_BE}}{Gross domestic product at market prices (index, 2015=100) for Belgium.}

\item{\verb{GDP_DE}}{Gross domestic product at market prices (index, 2015=100) for Germany.}

\item{\verb{GDP_FR}}{Gross domestic product at market prices (index, 2015=100) for France.}

\item{\verb{GDP_NL}}{Gross domestic product at market prices (index, 2015=100) for the Netherlands.}

\item{\verb{GDP_UK}}{Gross domestic product at market prices (index, 2015=100) for the United Kingdom.}

\item{\verb{CONS_BE}}{Final consumption expenditure (index, 2015=100) for Belgium.}

\item{\verb{CONS_DE}}{Final consumption expenditure (index, 2015=100) for Germany.}

\item{\verb{CONS_FR}}{Final consumption expenditure (index, 2015=100) for France.}

\item{\verb{CONS_NL}}{Final consumption expenditure (index, 2015=100) for the Netherlands.}

\item{\verb{CONS_UK}}{Final consumption expenditure (index, 2015=100) for the United Kingdom.}

\item{\verb{HICP_BE}}{Harmonised Indices of Consumer Prices (annual rate of change, 2015=100) for Belgium.}

\item{\verb{HICP_DE}}{Harmonised Indices of Consumer Prices (annual rate of change, 2015=100) for Germany.}

\item{\verb{HICP_FR}}{Harmonised Indices of Consumer Prices (annual rate of change, 2015=100) for France.}

\item{\verb{HICP_N}}{Harmonised Indices of Consumer Prices (annual rate of change, 2015=100) for the Netherlands.}

\item{\verb{HICP_UK}}{Harmonised Indices of Consumer Prices (annual rate of change, 2015=100) for the United Kingdom.}

\item{\verb{UR_BE}}{Unemployment rate (percentage of the active population) for Belgium.}

\item{\verb{UR_DE}}{Unemployment rate (percentage of the active population) for Germany.}

\item{\verb{UR_FR}}{Unemployment rate (percentage of the active population) for France.}

\item{\verb{UR_NL}}{Unemployment rate (percentage of the active population) for the Netherlands.}

\item{\verb{UR_UK}}{Unemployment rate (percentage of the active population) for the United Kingdom.}
}
}
\source{
https://ec.europa.eu/eurostat/data/database
}
\usage{
MacroTS
}
\description{
Macroeconomic data from Eurostat on GDP, consumption, inflation and unemployment for Belgium, Germany, France, the Netherlands and the United Kingdom.
}
\note{
\itemize{
\item Unemployment rates are seasonally but not calendar adjusted, all other series are both seasonally and calendar adjusted.
\item Quarterly inflation rates are sampled from Eurostat's monthly series with annual rates of change as the final month of the respective quarter.
\item The unemployment rate for France excludes overseas territories ('France continental' in the Eurostat database).}
}
\keyword{datasets}
