% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-dark-mode.R
\name{input_dark_mode}
\alias{input_dark_mode}
\alias{toggle_dark_mode}
\title{Dark mode input control}
\usage{
input_dark_mode(..., id = NULL, mode = NULL)

toggle_dark_mode(mode = NULL, ..., session = get_current_session())
}
\arguments{
\item{...}{Additional attributes to be passed to the input control UI, such
as \code{class}, \code{style}, etc.

In \code{toggle_dark_mode()}, the \code{...} are included for future extensibility
and are currently ignored.}

\item{id}{An optional input id, required to reactively read the current color
mode.}

\item{mode}{The initial mode of the dark mode switch. By default or when set
to \code{NULL}, the user's system settings for preferred color scheme will be
used. Otherwise, set to \code{"light"} or \code{"dark"} to force a particular initial
mode.}

\item{session}{A Shiny session object (the default should almost always be
used).}
}
\value{
Returns a UI element for a dark mode switch input control. The server
value received for the input corresponding to \code{id} will be a string value
with the current color mode (\code{"light"} or \code{"dark"}).
}
\description{
Creates a button that toggles between dark and light modes, specifically for
toggling between light and dark \href{https://getbootstrap.com/docs/5.3/customize/color-modes/}{Bootstrap color modes} -- a new
feature added in \href{https://getbootstrap.com/docs/5.3/migration/#color-modes}{Bootstrap 5.3}.
}
\section{Functions}{
\itemize{
\item \code{input_dark_mode()}: Create a dark mode switch input control

\item \code{toggle_dark_mode()}: Programmatically toggle or set the current light
or dark color mode.

}}
\seealso{
Other input controls: 
\code{\link{input_switch}()}
}
\concept{input controls}
