% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.r
\name{add.terms}
\alias{add.terms}
\title{Add terms to a formula}
\usage{
add.terms(formula, add)
}
\arguments{
\item{formula}{The formula to add terms to.}

\item{add}{A vector of terms to add. To add terms nested in random-effect groups, use `(term|group)' syntax if you want to add an independent random effect (e.g. `(olderterm|group) + (term|group)'), or use `term|group' syntax if you want to add a dependent random effect to a pre-existing term group (if no such group exists, it will be created at the end of the formula).}
}
\value{
The updated formula.
}
\description{
Add terms to a formula
}
\examples{
library(buildmer)
form <- Reaction ~ Days + (1|Subject)
add.terms(form,'Days|Subject')
add.terms(form,'(0+Days|Subject)')
add.terms(form,c('many','more|terms','to|terms','(be|added)','to|test'))
}
