% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_aBullPutSpread.R
\name{aBullPutSpread}
\alias{aBullPutSpread}
\title{Calculates Profit and Loss (PnL) per share (or unit of the underlying) and Breakeven point at expiration for Bull Put Spread and draws its graph in the Plots tab.}
\usage{
aBullPutSpread(
  ST,
  XH,
  XL,
  PH,
  PL,
  hl = 0,
  hu = 1.5,
  xlab = "Spot Price ($) on Expiration",
  ylab = "Profit / Loss [ PnL ] at Expiration ($)",
  main = "Bull Put Spread ",
  sub = "bullishTrader / MaheshP Kumar"
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{XH}{Higher Strike Price or eXercise price.}

\item{XL}{Lower Strike Price or eXercise price.}

\item{PH}{Option premium or option price received on put shorted at higher strike price (XH).}

\item{PL}{Option premium or option price paid on the put bought at lower strike price (XL).}

\item{hl}{lower bound value for setting lower limit of X axis displaying spot price.}

\item{hu}{upper bound value for setting upper limit of X axis displaying spot price.}

\item{xlab}{X axis label.}

\item{ylab}{Y axis label.}

\item{main}{Title of the Graph.}

\item{sub}{Subtitle of the Graph.}
}
\value{
returns a profit and loss graph of Bull Put Spread.
}
\description{
This is a vertical spread consisting of a long position in an OTM (out of the money) put option with a strike price XL, and a short position in another OTM (out of the money) put option with a higher strike price XH. This is a net credit (V0Cr) trade as option premium or option price (PH) received on put shorted at higher strike price (XH)  is more than premium (PL) paid on the put bought at lower strike price (XL). So, V0Cr is equal to PH minus PL. The  outlook of trader or investor is bullish (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration and also the Breakeven (BE) point for Bull Put Spread and draws its graph in the Plots tab.
}
\examples{
aBullPutSpread(17,17,15,1.50,0.50)
aBullPutSpread(50,50,48,4,2.6,hl=0.7,hu=1.2)
aBullPutSpread(1000,1000,995,40,37,hl=0.98,hu=1.02)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group.\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
