% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_callRatioBackspread.R
\name{callRatioBackspread}
\alias{callRatioBackspread}
\title{Calculates Profit and Loss (PnL) per share (or unit of the underlying) and Breakeven (BE) point at expiration for Call Ratio Backspread and draws its graph in the Plots tab.}
\usage{
callRatioBackspread(
  ST,
  X2H,
  X1L,
  CX2H,
  CX1L,
  hl = 0,
  hu = 1.7,
  xlab = "Spot Price ($) on Expiration",
  ylab = "Profit / Loss [ PnL ] at Expiration ($)",
  main = "Call Ratio Backspread ",
  sub = "bullishTrader / MaheshP Kumar"
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X2H}{Higher Strike Price or eXercise price.}

\item{X1L}{Lower Strike Price or eXercise price.}

\item{CX2H}{Call Premium received for the sold Calls at higher Strike.}

\item{CX1L}{Call Premium paid for the bought Calls at Lower Strike.}

\item{hl}{lower bound value for setting lower limit of X axis displaying spot price.}

\item{hu}{upper bound value for setting upper limit of X axis displaying spot price.}

\item{xlab}{X axis label.}

\item{ylab}{Y axis label.}

\item{main}{Title of the Graph.}

\item{sub}{Subtitle of the Graph.}
}
\value{
returns a profit and loss graph of Call ratio backspread.
}
\description{
This strategy consists of a short position one (or two) call options with a strike price X1L, and and buying two (or three) call options with a strike price X2H. The outlook of trader or investor is strongly bullish (Kakushadze & Serur, 2018) .
}
\details{
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration and also the Breakeven (BE) point for Call Ratio Backspread and draws its graph in the Plots tab. EXAMPLE, Buying two HypoERP December 30 calls at $2.50 and shorting HypoERP December 25 put at $4.90
}
\examples{
callRatioBackspread(25,30,25,2.50,4.90)
callRatioBackspread(25,30,25,2.20,4.90)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group.\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
