% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend.R
\name{legend}
\alias{legend}
\alias{legend.c3}
\title{C3 Legend Options}
\usage{
legend(c3, hide = FALSE, position = NULL, inset = NULL,
  item = NULL, ...)

\method{legend}{c3}(c3, hide = FALSE, position = NULL, inset = NULL,
  item = NULL, ...)
}
\arguments{
\item{c3}{c3 htmlwidget object}

\item{hide}{boolean or character of parameters to hide}

\item{position}{character one of 'bottom', 'right', 'inset'}

\item{inset}{list with options:
\itemize{
 \item{anchor}{: character one of 'top-left', 'top-right', 'bottom-left', 'bottom-right'}
 \item{x}{: integer pixels}
 \item{y}{: integer pixels}
 \item{step}{: numeric}
}}

\item{item}{list with options:
\itemize{
 \item{onclick}{: character js function, wrap character or character vector in JS()}
 \item{onmouseover}{: character js function, wrap character or character vector in JS()}
 \item{onmouseout}{: character js function, wrap character or character vector in JS()}
}}

\item{...}{additional options passed to the legend object}
}
\value{
c3
}
\description{
Modify plot elements that relate to the legend. The c3 legend is on by default, this function allows the
legend to be removed, or other legend attributes to be set.
}
\examples{
iris \%>\%
 c3(x='Sepal_Length', y='Sepal_Width', group = 'Species') \%>\%
 c3_scatter() \%>\%
 legend(position = 'right')

}
\seealso{
Other c3: \code{\link{RColorBrewer}}, \code{\link{c3}},
  \code{\link{grid}}, \code{\link{region}},
  \code{\link{subchart}}, \code{\link{tooltip}},
  \code{\link{xAxis}}, \code{\link{zoom}}
}
\concept{c3}
\concept{legend}
