% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cSEMNonlinearEffects.R
\name{plot.cSEMNonlinearEffects}
\alias{plot.cSEMNonlinearEffects}
\title{\code{cSEMNonlinearEffects} method for \code{plot()}}
\usage{
\method{plot}{cSEMNonlinearEffects}(x, .plot_type = "simpleeffects", .plot_package = "plotly", ...)
}
\arguments{
\item{x}{An R object of class \code{cSEMNonlinearEffects}.}

\item{.plot_type}{A character string indicating the type of plot that should be produced.
Options are "\emph{simpleeffects}", "\emph{surface}", and "\emph{floodlight}". Defaults to "\emph{simpleeffects}".}

\item{.plot_package}{A character vector indicating the plot package used. Options are
"\emph{plotly}", and "\emph{persp}". Defaults to "\emph{plotly}".}

\item{...}{Additional parameters that can be passed to
\code{\link[graphics:persp]{graphics::persp}}, e.g., to rotate the plot.}
}
\description{
This plot method can be used to create plots to analyze non-linear models in more
depth. In doing so the following plot types can be selected:
\describe{
\item{\code{.plot_type = "simpleeffects"}:}{
The plot of a simple effects analysis displays the predicted value of the
dependent variable for different values of the independent variable and the moderator.
As levels for the moderator the levels provided to the \code{doNonlinearEffectsAnalysis()} function
are used. Since the constructs are standardized the values of the moderator
equals the deviation from its mean measured in standard deviations.
}
\item{\code{.plot_type = "surface"}:}{
The plot of a surface analysis displays the predicted values of an
independent variable (z). The values are predicted based on the values of the moderator
and the independent variable including all their higher-order terms.
For the values of the moderator and the independent variable steps between
their minimum and maximum values  are used.
}
\item{\code{.plot_type = "floodlight"}:}{
The plot of a floodlight analysis displays the direct effect of an continuous
independent variable (z) on a dependent variable (y) conditional on the values
of a continuous moderator variable (x), including
the confidence interval and the Johnson-Neyman points. It is
noted that in the floodlight plot only moderation is taken into account and higher
order terms are ignored. For more details, see \insertCite{Spiller2013;textual}{cSEM}.
}
}
Plot the predicted values of an independent variable (z)
The values are predicted based on a certain moderator and a certain
independent variable including all their higher-order terms.
}
\seealso{
\code{\link[=doNonlinearEffectsAnalysis]{doNonlinearEffectsAnalysis()}}
}
