#' Population Data from KNBS Census
#'
#' Provides population statistics for counties and subcounties in Kenya, as per Volume 3 of the 2019 Kenya Population and Housing Census Table 2.3
#'
#' @format A tibble with 54 rows and 4 variables:
#' * country    - Character vector of country
#' * county     - Character vector of county names.
#' * subcounty  - Character vector of subcounty names.
#' * age        - The age distribution.
#' * sex        - The sex of the population.
#' * population - The number of this population.
#'
#' @source
#' Kenya National Bureau of Statistics (KNBS), 2019 Kenya Population and Housing Census Volume III: Distribution of populayion by Age, Sex and Administtrative units
#' <https://www.knbs.or.ke/download/2019-kenya-population-and-housing-census-volume-iii-distribution-of-population-by-age-sex-and-administrative-units/>
#'
#' @keywords internal
#' "population_data"
