% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateOxcalCode.R
\name{GenerateOxcalCode}
\alias{GenerateOxcalCode}
\title{Outputs code suitable for running in OxCal from a series of radiocarbon determinations}
\usage{
GenerateOxcalCode(
  model_name,
  rc_determinations,
  rc_sigmas,
  rc_names = NULL,
  F14C_inputs = FALSE,
  outfile_path = NULL
)
}
\arguments{
\item{model_name}{The name given to the model in the OxCal code.}

\item{rc_determinations}{A vector of observed radiocarbon determinations. Can be provided either as
\eqn{{}^{14}}C ages (in \eqn{{}^{14}}C yr BP) or as F\eqn{{}^{14}}C concentrations.}

\item{rc_sigmas}{A vector of the (1-sigma) measurement uncertainties for the
radiocarbon determinations. Must be the same length as \code{rc_determinations} and
given in the same units.}

\item{rc_names}{Optional. The name of each data point - if given it must be the same length of rc_determinations.}

\item{F14C_inputs}{\code{TRUE} if the provided \code{rc_determinations} are F\eqn{{}^{14}}C
concentrations and \code{FALSE} if they are radiocarbon ages. Defaults to \code{FALSE}.}

\item{outfile_path}{Optional. If given the OxCal code will be output to the file at the path given, otherwise it
will be output to the terminal.}
}
\value{
None
}
\description{
Outputs code suitable for running in OxCal from a series of radiocarbon determinations
that can be given as either \eqn{{}^{14}}C age or F\eqn{{}^{14}}C.
}
\examples{
# Generate names automatically and outputs to the screen for 14C ages
GenerateOxcalCode("My_data", c(1123, 1128, 1135), c(32, 24, 25))

# Provide name automatically and outputs to the screen for F14C concentrations
GenerateOxcalCode(
  "My_data",
  c(0.832, 0.850, 0.846),
  c(0.004, 0.003, 0.009),
  c("P-1", "P-2", "P-3"),
  F14C_inputs=TRUE)

}
