% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{shcal20}
\alias{shcal20}
\title{SHCal20 calibration curve}
\format{
\subsection{\code{shcal20}}{

A data frame with 9,501 rows and 5 columns providing the SHCal20 radiocarbon age
calibration curve on a calendar grid spanning from 55,000--0 cal yr BP:
\describe{
\item{calendar_age}{The calendar age (in cal yr BP)}
\item{c14_age}{The \eqn{{}^{14}}C age (in \eqn{{}^{14}}C yr BP)}
\item{c14_sig}{The (1-\eqn{\sigma}) uncertainty in the \eqn{{}^{14}}C age}
\item{f14c}{The \eqn{{}^{14}}C age expressed as F\eqn{{}^{14}}C concentration}
\item{f14c_sig}{The (1-\eqn{\sigma}) uncertainty in the F\eqn{{}^{14}}C concentration}
}
}
}
\source{
http://doi.org/10.1017/RDC.2020.59
}
\usage{
shcal20
}
\description{
The SHCal20 Southern Hemisphere radiocarbon age calibration curve
on a calendar grid spanning from 55,000--0 cal yr BP
(Before Present, 0 cal yr BP corresponds to 1950 CE). \cr \cr
\emph{Note:} This dataset provides \eqn{{}^{14}}C ages and F\eqn{{}^{14}}C values
on a calendar age grid. This is different from the \eqn{{}^{14}}C ages
and \eqn{{\Delta}^{14}}C values provided in oxcal .14c files.\cr \cr
\strong{Reference:} \cr Hogg AG, Heaton TJ, Hua Q, Palmer JG, Turney CSM, Southon J, Bayliss A, Blackwell PG,
Boswijk G, Bronk Ramsey C, Pearson C, Petchey F, Reimer P, Reimer R, Wacker L.
2020.
SHCal20 Southern Hemisphere calibration, 0--55,000 years cal BP.
\emph{Radiocarbon} \strong{62} https://doi.org/10.1017/RDC.2020.59. \cr \cr
}
\keyword{datasets}
