% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_for_cran.R
\name{build_for_cran}
\alias{build_for_cran}
\title{Build a Source Package for Submission to CRAN}
\usage{
build_for_cran(...)
}
\arguments{
\item{...}{Options passed to \code{R CMD build}.}
}
\value{
The exit status code{R CMD build}, invisibly.
}
\description{
This function builds a source package in preparation for submission to
\href{https://cran.r-project.org/}{The Comprehensive R Archive Network (CRAN)}.
and saved it in the root of a package.
In particular, Rust crates upon which the package depends are \dQuote{vendored}
within the source package in the archive file \code{src/rust/vendor.tar.xz}, so
that lacking internet access will not give a check warning nor error on CRAN.
The package's \code{configure} script tests for the existence of this archive
file and, when present, runs Cargo (Rust's package manager) in compliance with the
\href{https://cran.r-project.org/web/packages/policies.html}{CRAN Repository Policies}
in that Cargo will only use two CPU cores and will clean-up cached values (i.e.,
remove detritus).
}
\details{
Since depending crates are vendored, the authorship and copyright must be
declared in the \code{DESCRIPTION} file prior to building the source package
for CRAN. See the \code{\link{authors}} function for help in attribution.

This function will rebuild \pkg{roxygen2} documentation if the DESCRIPTION
file indicates that \pkg{roxygen2} is used and the package is installed.

This function does not test the package. The developer is strongly encouraged
to both inspect and test the package before submitting to CRAN.
}
