% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowcontig.R
\name{flowcontig}
\alias{flowcontig}
\title{Builds an ordinal distance matrices from a spatial features background}
\usage{
flowcontig(bkg, code, k, algo)
}
\arguments{
\item{bkg}{a layer of areal spatial features (eg. the map background)}

\item{code}{spatial areal features code}

\item{k}{order of adjacency or contiguity between two areal spatial features}

\item{algo}{algorithm to use for ordinal distance calculation. Default is "Dijkstra's"  algorithm. See Details.}
}
\value{
a contiguity matrice with the k orders of adjacency
}
\description{
From a layer of areal spatial features, compute an ordinal distance matrice
based on a k order criterion of adjacency or contiguity between origin and destination places . \cr
The result is a neighbourhood graph that can be used for filtering flow values before flow mapping (\link{flowmap})
}
\details{
The (k=1,2,...,k) order of adjacency or contiguity, of an areal spatial features
background, is the number of spatial boundaries to be crossed between
a couple of origin-destination (ODs) places. The k number can be assimilated to a shortest path between two pair of nodes
Argument `k` is to enter the number k of the contiguity matrix to be constructed ;\cr
-ordre=1 : ODs places are adjacent, ie the flow have to cross only 1 boundary\cr
-ordre=2 : ODs places are distant from 2 borders\cr
-ordre=k : ODs places are distant from k borders\cr
The function returns also the (k) number of the layer
}
\examples{
library(cartograflow)
library(sf)
data(flowdata)
map <- st_read(system.file("shape/MGP_TER.shp", package = "cartograflow"))
graph_ckij_1 <- flowcontig(bkg = map, code = "EPT_NUM", k = 1, algo = "automatic")
\donttest{
flowmap(
  tab = graph_ckij_1,
  fij = "ordre", origin.f = "i", destination.f = "j",
  bkg = map, code = "EPT_NUM", nodes.X = "X", nodes.Y = "Y",
  filter = FALSE
)
}
}
