% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mst.R
\name{sc_skewed}
\alias{sc_skewed}
\alias{sc_skewed.default}
\alias{sc_skewed.scree}
\alias{sc_skewed.igraph}
\title{Compute skewed scagnostic measure using MST}
\usage{
sc_skewed(x, y)

\method{sc_skewed}{default}(x, y)

\method{sc_skewed}{scree}(x, y = NULL)

\method{sc_skewed}{igraph}(x, y)
}
\arguments{
\item{x}{numeric vector of x values}

\item{y}{numeric vector of y values}
}
\value{
A "numeric" object that gives the plot's skewed score.
}
\description{
Compute skewed scagnostic measure using MST
}
\examples{
  require(ggplot2)
  require(tidyr)
  require(dplyr)
  data(anscombe_tidy)
  ggplot(datasaurus_dozen, aes(x=x, y=y)) +
    geom_point() +
    facet_wrap(~dataset, ncol=3, scales = "free")
  sc_skewed(datasaurus_dozen_wide$dots_x, datasaurus_dozen_wide$dots_y)
  sc_skewed(datasaurus_dozen_wide$h_lines_x, datasaurus_dozen_wide$h_lines_y)
  sc_skewed(datasaurus_dozen_wide$x_shape_x, datasaurus_dozen_wide$x_shape_y)

}
